/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.device.explorer.ui;

import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.device.explorer.DeviceExplorerModel;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerPanel;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerView;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewImpl;
import com.android.tools.idea.device.explorer.ui.DeviceExplorerViewListener;
import com.android.tools.idea.deviceprovisioner.DeviceHandleRenderer;
import com.android.tools.idea.deviceprovisioner.DeviceHandleRendererKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceExplorerEvent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import icons.StudioIllustrations;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u000223B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u000e\u0010\u001f\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010 J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020\u0018H\u0002J\b\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u00020\u0018H\u0002J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.H\u0007J\b\u00100\u001a\u000201H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewImpl;", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerView;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;", "toolWindowID", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/device/explorer/DeviceExplorerModel;Ljava/lang/String;)V", "listeners", "", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewListener;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "panel", "Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerPanel;", "selectedTabIndex", "", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "addListener", "", "listener", "removeListener", "setup", "addTab", "tab", "title", "trackDeviceListChanges", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "trackActiveDeviceChanges", "reportErrorGeneric", "message", "t", "", "reportError", "showPanel", "showActiveDeviceScreen", "showNoDeviceScreen", "trackAction", "action", "Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;", "getDeviceCombo", "Ljavax/swing/JComboBox;", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "getTabPane", "Ljavax/swing/JTabbedPane;", "DeviceNameRenderer", "Companion", "intellij.android.device-explorer"})
public final class DeviceExplorerViewImpl
implements DeviceExplorerView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeviceExplorerModel model;
    @NotNull
    private final String toolWindowID;
    @NotNull
    private final List<DeviceExplorerViewListener> listeners;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @NotNull
    private final DeviceExplorerPanel panel;
    private int selectedTabIndex;
    @NotNull
    private static final Map<String, DeviceExplorerEvent.Action> TAB_TO_ACTION_MAP;

    public DeviceExplorerViewImpl(@NotNull Project project, @NotNull DeviceExplorerModel model, @NotNull String toolWindowID) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)toolWindowID, (String)"toolWindowID");
        this.model = model;
        this.toolWindowID = toolWindowID;
        this.listeners = new ArrayList();
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project, 0, 4, null);
        this.panel = new DeviceExplorerPanel();
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.loadingPanel;
    }

    @Override
    public void addListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull DeviceExplorerViewListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void setup() {
        JPanel jPanel = this.panel.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getComponent(...)");
        this.loadingPanel.add((Component)jPanel, (Object)"Center");
        this.panel.getDeviceCombo().setRenderer((ListCellRenderer)((Object)new DeviceNameRenderer()));
        this.panel.getDeviceCombo().setBackground(JBColor.background());
        this.panel.getDeviceCombo().addActionListener(arg_0 -> DeviceExplorerViewImpl.setup$lambda$2(this, arg_0));
        this.panel.getTabPane().addChangeListener(arg_0 -> DeviceExplorerViewImpl.setup$lambda$4(this, arg_0));
        this.showPanel();
    }

    @Override
    public void addTab(@NotNull JComponent tab, @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        this.panel.getTabPane().addTab(title2, tab);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object trackDeviceListChanges(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof trackDeviceListChanges.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerViewImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.trackDeviceListChanges((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                devicesInComboBox = new LinkedHashSet<E>();
                $continuation.label = 1;
                v0 = this.model.getDevices().collect(new FlowCollector(devicesInComboBox, this){
                    final /* synthetic */ Set<DeviceHandle> $devicesInComboBox;
                    final /* synthetic */ DeviceExplorerViewImpl this$0;
                    {
                        this.$devicesInComboBox = $devicesInComboBox;
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object emit(List<? extends DeviceHandle> newDevices, Continuation<? super Unit> $completion) {
                        void $this$forEach$iv;
                        Iterable iterable = SetsKt.minus(this.$devicesInComboBox, (Iterable)CollectionsKt.toSet((Iterable)newDevices));
                        Set<DeviceHandle> set2 = this.$devicesInComboBox;
                        DeviceExplorerViewImpl deviceExplorerViewImpl = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            DeviceHandle it = (DeviceHandle)element$iv;
                            boolean bl = false;
                            set2.remove(it);
                            DeviceExplorerViewImpl.access$getPanel$p(deviceExplorerViewImpl).getDeviceCombo().removeItem(it);
                        }
                        for (DeviceHandle deviceHandle : newDevices) {
                            if (!this.$devicesInComboBox.add(deviceHandle)) continue;
                            DeviceExplorerViewImpl.access$getPanel$p(this.this$0).getDeviceCombo().addItem(deviceHandle);
                        }
                        DeviceExplorerViewImpl.access$showPanel(this.this$0);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl21:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object trackActiveDeviceChanges(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof trackActiveDeviceChanges.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DeviceExplorerViewImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.trackActiveDeviceChanges((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.model.getActiveDevice().collect(new FlowCollector(this){
                    final /* synthetic */ DeviceExplorerViewImpl this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final Object emit(DeviceHandle it, Continuation<? super Unit> $completion) {
                        DeviceExplorerViewImpl.access$getPanel$p(this.this$0).getDeviceCombo().setSelectedItem(it);
                        return Unit.INSTANCE;
                    }
                }, (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void reportErrorGeneric(@NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.reportError(message, t);
    }

    private final void reportError(String message, Throwable t) {
        if (t instanceof CancellationException) {
            return;
        }
        String updatedMessage = t.getMessage() != null ? message + ": " + t.getMessage() : message;
        Notification notification = new Notification(this.toolWindowID, this.toolWindowID, updatedMessage, NotificationType.WARNING);
        ApplicationManager.getApplication().invokeLater(() -> DeviceExplorerViewImpl.reportError$lambda$5(notification));
    }

    private final void showPanel() {
        if (this.panel.getDeviceCombo().getItemCount() == 0) {
            this.showNoDeviceScreen();
        } else {
            this.showActiveDeviceScreen();
        }
    }

    private final void showActiveDeviceScreen() {
        this.panel.showTabs();
    }

    private final void showNoDeviceScreen() {
        this.panel.showMessageLayer("Connect a device via USB cable or run an Android Virtual Device", StudioIllustrations.Common.DEVICES_LINEUP, false);
    }

    private final void trackAction(DeviceExplorerEvent.Action action2) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DEVICE_EXPLORER).setDeviceExplorerEvent(DeviceExplorerEvent.newBuilder().setAction(action2));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setDeviceExplorerEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    @TestOnly
    @NotNull
    public final JComboBox<DeviceHandle> getDeviceCombo() {
        JComboBox<DeviceHandle> jComboBox = this.panel.getDeviceCombo();
        Intrinsics.checkNotNullExpressionValue(jComboBox, (String)"getDeviceCombo(...)");
        return jComboBox;
    }

    @TestOnly
    @NotNull
    public final JTabbedPane getTabPane() {
        JTabbedPane jTabbedPane = this.panel.getTabPane();
        Intrinsics.checkNotNullExpressionValue((Object)jTabbedPane, (String)"getTabPane(...)");
        return jTabbedPane;
    }

    private static final void setup$lambda$2$lambda$0(Object $sel, DeviceExplorerViewListener it) {
        it.deviceSelected((DeviceHandle)$sel);
    }

    private static final void setup$lambda$2$lambda$1(DeviceExplorerViewListener it) {
        it.noDeviceSelected();
    }

    private static final void setup$lambda$2(DeviceExplorerViewImpl this$0, ActionEvent it) {
        Object sel = this$0.panel.getDeviceCombo().getSelectedItem();
        if (sel instanceof DeviceHandle) {
            this$0.listeners.forEach(arg_0 -> DeviceExplorerViewImpl.setup$lambda$2$lambda$0(sel, arg_0));
        } else {
            this$0.listeners.forEach(DeviceExplorerViewImpl::setup$lambda$2$lambda$1);
        }
    }

    private static final void setup$lambda$4(DeviceExplorerViewImpl this$0, ChangeEvent it) {
        block1: {
            Object object = it.getSource();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JTabbedPane");
            int newSelectedTabIndex = ((JTabbedPane)object).getSelectedIndex();
            if (newSelectedTabIndex == this$0.selectedTabIndex) break block1;
            this$0.selectedTabIndex = newSelectedTabIndex;
            Object object2 = it.getSource();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type javax.swing.JTabbedPane");
            String tabName = ((JTabbedPane)object2).getTitleAt(newSelectedTabIndex);
            DeviceExplorerEvent.Action action2 = TAB_TO_ACTION_MAP.get(tabName);
            if (action2 != null) {
                DeviceExplorerEvent.Action action3 = action2;
                boolean bl = false;
                this$0.trackAction(action3);
            }
        }
    }

    private static final void reportError$lambda$5(Notification $notification) {
        Notifications.Bus.notify((Notification)$notification);
    }

    public static final /* synthetic */ DeviceExplorerPanel access$getPanel$p(DeviceExplorerViewImpl $this) {
        return $this.panel;
    }

    public static final /* synthetic */ void access$showPanel(DeviceExplorerViewImpl $this) {
        $this.showPanel();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Files", (Object)DeviceExplorerEvent.Action.FILES_TAB_CLICKED), TuplesKt.to((Object)"Processes", (Object)DeviceExplorerEvent.Action.PROCESS_TAB_CLICKED)};
        TAB_TO_ACTION_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewImpl$Companion;", "", "<init>", "()V", "TAB_TO_ACTION_MAP", "", "", "Lcom/google/wireless/android/sdk/stats/DeviceExplorerEvent$Action;", "getTAB_TO_ACTION_MAP", "()Ljava/util/Map;", "intellij.android.device-explorer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, DeviceExplorerEvent.Action> getTAB_TO_ACTION_MAP() {
            return TAB_TO_ACTION_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J:\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/device/explorer/ui/DeviceExplorerViewImpl$DeviceNameRenderer;", "Lcom/intellij/ui/ColoredListCellRenderer;", "Lcom/android/sdklib/deviceprovisioner/DeviceHandle;", "<init>", "()V", "customizeCellRenderer", "", "list", "Ljavax/swing/JList;", "value", "index", "", "selected", "", "hasFocus", "intellij.android.device-explorer"})
    private static final class DeviceNameRenderer
    extends ColoredListCellRenderer<DeviceHandle> {
        protected void customizeCellRenderer(@NotNull JList<? extends DeviceHandle> list, @Nullable DeviceHandle value2, int index, boolean selected, boolean hasFocus) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (value2 == null) {
                this.append("No Connected Devices", SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            ColoredTextContainer coloredTextContainer = (ColoredTextContainer)this;
            ListModel<? extends DeviceHandle> listModel = list.getModel();
            Intrinsics.checkNotNullExpressionValue(listModel, (String)"getModel(...)");
            DeviceHandleRenderer.renderDevice(coloredTextContainer, value2, DeviceHandleRendererKt.toIterable(listModel));
        }
    }
}

