/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.devicemanagerv2;

import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.sdklib.deviceprovisioner.DeviceHandle;
import com.android.sdklib.deviceprovisioner.DeviceState;
import com.android.tools.idea.device.explorer.DeviceExplorerService;
import com.android.tools.idea.devicemanagerv2.DeviceActionsKt;
import com.android.tools.idea.devicemanagerv2.DeviceManagerBundle;
import com.android.tools.idea.devicemanagerv2.DeviceManagerUsageTracker;
import com.android.tools.idea.devicemanagerv2.DeviceRowData;
import com.google.wireless.android.sdk.stats.DeviceManagerEvent;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/devicemanagerv2/OpenDeviceExplorerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.android.device-manager-v2"})
public final class OpenDeviceExplorerAction
extends DumbAwareAction {
    public OpenDeviceExplorerAction() {
        super("Open in Device Explorer", DeviceManagerBundle.message("openDeviceExplorerButton.tooltip", new Object[0]), AllIcons.Actions.MenuOpen);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            DeviceHandle deviceHandle = com.android.tools.idea.deviceprovisioner.DeviceActionsKt.deviceHandle(e);
            e.getPresentation().setEnabled((deviceHandle != null ? deviceHandle.getState() : null) instanceof DeviceState.Connected);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DeviceRowData deviceRowData = DeviceActionsKt.deviceRowData(e);
        if (deviceRowData == null) {
            return;
        }
        DeviceRowData deviceRowData2 = deviceRowData;
        Object object = deviceRowData2.getHandle();
        if (object == null || (object = object.getState()) == null || (object = object.getConnectedDevice()) == null || (object = ConnectedDeviceKt.getSerialNumber((ConnectedDevice)object)) == null) {
            return;
        }
        Object serialNumber = object;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!project2.isDisposed()) {
            DeviceManagerUsageTracker.INSTANCE.logDeviceManagerEvent(deviceRowData2.isVirtual() ? DeviceManagerEvent.EventKind.VIRTUAL_DEVICE_FILE_EXPLORER_ACTION : DeviceManagerEvent.EventKind.PHYSICAL_DEVICE_FILE_EXPLORER_ACTION);
            DeviceExplorerService.openAndShowDevice(project2, (String)serialNumber);
        }
    }
}

