/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.android.tools.idea.diagnostics.LastActionTracker;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class ActionsReportContributor
implements DiagnosticReportContributor,
LastActionTracker.Listener {
    private final StringBuffer myReport = new StringBuffer();
    private final AtomicInteger myActionsCount = new AtomicInteger();
    private static final int MAX_ACTIONS_COUNT = 20;

    @Override
    public void setup(DiagnosticReportConfiguration configuration2) {
    }

    @Override
    public void startCollection(long timeElapsedSoFarMs) {
        LastActionTracker tracker = LastActionTracker.getInstance();
        String actionId = tracker.getCurrentActionId();
        long actionDurationMs = tracker.getCurrentDurationMs();
        this.myReport.append("Actions:\n");
        this.myReport.append("Action when freeze detected: " + actionId + "\n");
        this.myReport.append("Action duration when freeze detected: " + actionDurationMs + "ms\n");
        tracker.registerActionDurationListener(this);
    }

    @Override
    public void stopCollection(long totalDurationMs) {
        LastActionTracker tracker = LastActionTracker.getInstance();
        tracker.unregisterActionDurationListener(this);
        this.myReport.append("Action when freeze ended: " + tracker.getCurrentActionId() + "\n");
        this.myReport.append("Action duration when freeze ended: " + tracker.getCurrentDurationMs() + "ms\n");
    }

    @Override
    public void actionStarted(String actionId) {
        int value2 = this.myActionsCount.incrementAndGet();
        if (value2 <= 20) {
            this.myReport.append("Action started: " + actionId + "\n");
            if (value2 == 20) {
                this.myReport.append("Maximum number of actions reached.\n");
            }
        }
    }

    @Override
    public void actionFinished(String actionId, long durationMs) {
        if (this.myActionsCount.get() <= 20) {
            this.myReport.append("Action finished: " + actionId + ", duration: " + durationMs + "ms\n");
        }
    }

    @Override
    public String getReport() {
        return this.myReport.toString();
    }

    @Override
    public void generateReport(BiConsumer<String, String> saveReportCallback) {
        saveReportCallback.accept("actionsDiagnostics", this.getReport());
    }
}

