/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.tools.idea.diagnostics.ActionsReportContributor;
import com.android.tools.idea.diagnostics.CPUUseReportContributor;
import com.android.tools.idea.diagnostics.DiagnosticReportConfiguration;
import com.android.tools.idea.diagnostics.DiagnosticReportContributor;
import com.android.tools.idea.diagnostics.DiagnosticReportIdePerformanceListener;
import com.android.tools.idea.diagnostics.LockStatusReportContributor;
import com.android.tools.idea.diagnostics.MemoryUseReportContributor;
import com.android.tools.idea.diagnostics.ThreadSamplingReportContributor;
import com.android.tools.idea.diagnostics.report.DiagnosticReport;
import com.android.tools.idea.diagnostics.report.FreezeReport;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagnosticReportBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.diagnostics.DiagnosticReportBuilder");
    public static final long MAX_DURATION_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.maxDurationMs", TimeUnit.SECONDS.toMillis(60L));
    public static final long INTERVAL_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.intervalMs", 100L);
    public static final long FRAME_IGNORE_THRESHOLD_MS = Long.getLong("studio.diagnostic.uiFreezeSampling.frameIgnoreThresholdMs", 200L);
    public static final int MAX_REPORTS = Integer.getInteger("studio.diagnostic.uiFreezeSampling.maxReports", (Boolean)StudioFlags.HIGHER_DEFAULT_UI_FREEZE_REPORTS_COUNT.get() != false ? 10 : 3);
    @NotNull
    private final Object LOCK = new Object();
    private final long myStartTime;
    private final long myFreezeTimeBeforeCreated;
    @NotNull
    private final DiagnosticReportIdePerformanceListener.Controller myController;
    @NotNull
    private final ScheduledFuture<?> myFutureStop;
    private boolean myIsStopped;
    @NotNull
    private final List<DiagnosticReportContributor> myReportContributors;
    @NotNull
    private final Map<String, Path> myBinaryReportPaths;
    private boolean myIsTimedOut;

    public DiagnosticReportBuilder(long intervalMs, long maxSamplingTimeMs, long frameTimeIgnoreThresholdMs, long freezeTimeBeforeCreatedMs, @NotNull DiagnosticReportIdePerformanceListener.Controller controller2) {
        if (intervalMs <= 0L) {
            throw new IllegalArgumentException("intervalMs must be > 0");
        }
        if (maxSamplingTimeMs < 0L) {
            throw new IllegalArgumentException("maxSamplingTimeMs must be >= 0");
        }
        this.myController = controller2;
        this.myReportContributors = Arrays.asList(new ThreadSamplingReportContributor(), new LockStatusReportContributor(), new MemoryUseReportContributor(), new ActionsReportContributor(), new CPUUseReportContributor());
        this.myBinaryReportPaths = new TreeMap<String, Path>();
        this.myFreezeTimeBeforeCreated = freezeTimeBeforeCreatedMs;
        DiagnosticReportConfiguration configuration2 = new DiagnosticReportConfiguration(intervalMs, maxSamplingTimeMs, frameTimeIgnoreThresholdMs);
        for (DiagnosticReportContributor contributor : this.myReportContributors) {
            try {
                contributor.setup(configuration2);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        this.myStartTime = System.currentTimeMillis();
        for (DiagnosticReportContributor contributor : this.myReportContributors) {
            try {
                contributor.startCollection(freezeTimeBeforeCreatedMs);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }
        this.myFutureStop = JobScheduler.getScheduler().schedule(this::stopAfterTimeout, maxSamplingTimeMs, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAfterTimeout() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsStopped) {
                return;
            }
            this.myIsTimedOut = true;
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DiagnosticReport generateReport(long totalDurationMs) {
        Object object = this.LOCK;
        synchronized (object) {
            HashMap reportPaths = new HashMap();
            for (DiagnosticReportContributor contributor : this.myReportContributors) {
                contributor.generateReport((name2, contents) -> {
                    Path path = this.myController.saveReportFile((String)name2, (String)contents);
                    if (path != null) {
                        assert (!reportPaths.containsKey(name2));
                        reportPaths.put(name2, path);
                    }
                });
            }
            if (!reportPaths.containsKey("hotPathStackTrace")) {
                return null;
            }
            Path hotPathStackTrace = (Path)reportPaths.remove("hotPathStackTrace");
            return new FreezeReport(hotPathStackTrace, reportPaths, this.myBinaryReportPaths, this.myIsTimedOut, totalDurationMs, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myIsStopped) {
                return;
            }
            long stopTime = System.currentTimeMillis();
            long totalDurationMs = stopTime - this.myStartTime + this.myFreezeTimeBeforeCreated;
            for (DiagnosticReportContributor contributor : this.myReportContributors) {
                try {
                    contributor.stopCollection(totalDurationMs);
                }
                catch (Throwable t) {
                    LOG.error(t);
                }
            }
            this.myIsStopped = true;
            this.myFutureStop.cancel(false);
            DiagnosticReport report = this.generateReport(totalDurationMs);
            this.myController.reportReady(report);
        }
    }

    public static void registerPerformanceListener(Consumer<DiagnosticReport> reportCallback) {
        new DiagnosticReportIdePerformanceListener(reportCallback).registerOn(ApplicationManager.getApplication());
    }
}

