/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.FieldCache;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotStatistics;
import com.android.tools.idea.diagnostics.heap.HeapSnapshotTraverseException;
import com.android.tools.idea.diagnostics.heap.HeapTraverseNode;
import com.android.tools.idea.diagnostics.heap.HeapTraverseUtil;
import com.android.tools.idea.diagnostics.heap.MemoryReportJniHelper;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.rendering.imagepool.ImagePool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.TriConsumer;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapTraverseChildProcessor {
    private static final Set<String> REFERENCE_CLASS_FIELDS_TO_IGNORE = Set.of("referent", "discovered", "next");
    private static final String ARRAY_ELEMENT_REFERENCE_LABEL = "[]";
    private static final String STATIC_FIELD_REFERENCE_LABEL = "(static)";
    private static final String DISPOSER_TREE_REFERENCE_LABEL = "(disposer-tree)";
    @NotNull
    private final Object myDisposerTree = Disposer.getTree();
    private final boolean myShouldUseDisposerTreeReferences = (Boolean)StudioFlags.USE_DISPOSER_TREE_REFERENCES.get();
    @NotNull
    private final HeapSnapshotStatistics myStatistics;

    public HeapTraverseChildProcessor(@NotNull HeapSnapshotStatistics statistics) {
        this.myStatistics = statistics;
    }

    void processChildObjects(@Nullable Object obj, @NotNull TriConsumer<Object, HeapTraverseNode.RefWeight, String> consumer2, @NotNull FieldCache fieldCache) throws HeapSnapshotTraverseException {
        if (obj == null) {
            return;
        }
        if (obj == this.myDisposerTree) {
            return;
        }
        Class<?> nodeClass = obj.getClass();
        boolean objIsReference = obj instanceof Reference;
        boolean isImagePoolClass = obj instanceof ImagePool;
        for (Field field2 : fieldCache.getInstanceFields(nodeClass)) {
            if (objIsReference && REFERENCE_CLASS_FIELDS_TO_IGNORE.contains(field2.getName())) continue;
            try {
                if (isImagePoolClass && "myReferences".equals(field2.getName())) continue;
                Object value2 = field2.get(obj);
                consumer2.accept(value2, (Object)HeapTraverseNode.RefWeight.INSTANCE_FIELD, (Object)field2.getName());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                this.myStatistics.incrementUnsuccessfulFieldAccessCounter();
            }
        }
        if (nodeClass.isArray() && !HeapTraverseUtil.isArrayOfPrimitives(nodeClass)) {
            for (Object value3 : (Object[])obj) {
                consumer2.accept(value3, (Object)HeapTraverseNode.RefWeight.ARRAY_ELEMENT, (Object)ARRAY_ELEMENT_REFERENCE_LABEL);
            }
        }
        if (obj instanceof Class && MemoryReportJniHelper.isClassInitialized((Class)obj)) {
            for (Object fieldValue : fieldCache.getStaticFields((Class)obj)) {
                if (fieldValue == null) continue;
                consumer2.accept(fieldValue, (Object)HeapTraverseNode.RefWeight.STATIC_FIELD, (Object)STATIC_FIELD_REFERENCE_LABEL);
            }
        }
        if (this.myShouldUseDisposerTreeReferences && obj instanceof Disposable) {
            Object objToNodeMap = HeapTraverseUtil.getFieldValue(this.myDisposerTree, "myObject2NodeMap");
            if (!(objToNodeMap instanceof Map)) {
                return;
            }
            Object disposableTreeNode = ((Map)objToNodeMap).get(obj);
            if (disposableTreeNode == null) {
                return;
            }
            Object disposableTreeNodeChildren = HeapTraverseUtil.getFieldValue(disposableTreeNode, "myChildren");
            if (!(disposableTreeNodeChildren instanceof List)) {
                return;
            }
            for (Object child : (List)disposableTreeNodeChildren) {
                Object currDisposable = HeapTraverseUtil.getFieldValue(child, "myObject");
                if (!(currDisposable instanceof Disposable)) continue;
                consumer2.accept(currDisposable, (Object)HeapTraverseNode.RefWeight.DISPOSER_TREE_REFERENCE, (Object)DISPOSER_TREE_REFERENCE_LABEL);
            }
        }
    }
}

