/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.heap;

import com.android.tools.idea.diagnostics.heap.MemoryReportCollector;
import com.android.tools.idea.diagnostics.heap.ObjectsStatistics;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeapTraverseUtil {
    static boolean isArrayOfPrimitives(@NotNull Class<?> type) {
        return type.isArray() && HeapTraverseUtil.isPrimitive(type.getComponentType());
    }

    public static void processMask(long mask, @NotNull Consumer<Integer> p) {
        int trailingZeros = Long.numberOfTrailingZeros(mask);
        mask >>= Long.numberOfTrailingZeros(mask);
        int i = trailingZeros;
        while (mask != 0L) {
            if ((mask & 1L) != 0L) {
                p.accept(i);
            }
            ++i;
            mask >>= 1;
        }
    }

    public static boolean isPrimitive(@NotNull Class<?> type) {
        return type.isPrimitive();
    }

    @NotNull
    public static String getObjectsSizePresentation(long bytes2, MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle style) {
        if (style == MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.PLAIN_VALUES) {
            return String.format(Locale.US, "%d bytes", bytes2);
        }
        return HeapReportUtils.INSTANCE.toShortStringAsSize(bytes2);
    }

    @NotNull
    public static String getObjectsCountPresentation(int count, MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle style) {
        if (style == MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle.OPTIMAL_UNITS) {
            return HeapReportUtils.INSTANCE.toShortStringAsCount(count);
        }
        return Integer.toString(count);
    }

    @NotNull
    public static String getObjectsStatsPresentation(ObjectsStatistics statistics, MemoryReportCollector.HeapSnapshotPresentationConfig.PresentationStyle style) {
        return String.format(Locale.US, "%s/%s objects", HeapTraverseUtil.getObjectsSizePresentation(statistics.getTotalSizeInBytes(), style), HeapTraverseUtil.getObjectsCountPresentation(statistics.getObjectsCount(), style));
    }

    @Nullable
    static Object getFieldValue(@NotNull Object object, @NotNull String fieldName) {
        try {
            Field field2 = object.getClass().getDeclaredField(fieldName);
            field2.setAccessible(true);
            return field2.get(object);
        }
        catch (ReflectiveOperationException e) {
            throw new Error(e);
        }
    }
}

