/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.navigator;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.HProfMetadata;
import com.android.tools.idea.diagnostics.hprof.classstore.StaticField;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigatorOnAuxFiles;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.visitors.CreateAuxiliaryFilesVisitor;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 12\u00020\u0001:\u0004./01B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH&J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u0016H&J\b\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0018H&J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0005H&J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\f\u001a\u00020\u0005H&J\b\u0010\u001e\u001a\u00020\u001fH&J\b\u0010 \u001a\u00020\u0005H&J\b\u0010!\u001a\u00020\u0005H&J\b\u0010\"\u001a\u00020\u001fH&J\u0018\u0010#\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020%J\u0018\u0010'\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010(\u001a\u00020%J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\u0018\u0010*\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020,H&J\b\u0010-\u001a\u00020\u001fH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u00062"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "instanceCount", "", "<init>", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;J)V", "getClassStore", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "getInstanceCount", "()J", "id", "getId", "createRootsIterator", "", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$RootObject;", "goTo", "", "referenceResolution", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$ReferenceResolution;", "getClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getReferencesCopy", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "copyReferencesTo", "outReferences", "getClassForObjectId", "getRootReasonForObjectId", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "getObjectSize", "", "getSoftReferenceId", "getWeakReferenceId", "getSoftWeakReferenceIndex", "goToInstanceField", "className", "", "fieldName", "getInstanceFieldObjectId", "name", "goToStaticField", "getStaticFieldObjectId", "isNull", "", "getExtraData", "ReferenceResolution", "RootObject", "NavigationException", "Companion", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nObjectNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectNavigator.kt\ncom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n360#2,7:115\n1310#3,2:122\n*S KotlinDebug\n*F\n+ 1 ObjectNavigator.kt\ncom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator\n*L\n70#1:115,7\n84#1:122,2\n*E\n"})
public abstract class ObjectNavigator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassStore classStore;
    private final long instanceCount;

    public ObjectNavigator(@NotNull ClassStore classStore, long instanceCount) {
        Intrinsics.checkNotNullParameter((Object)classStore, (String)"classStore");
        this.classStore = classStore;
        this.instanceCount = instanceCount;
    }

    @NotNull
    public final ClassStore getClassStore() {
        return this.classStore;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    public abstract long getId();

    @NotNull
    public abstract Iterator<RootObject> createRootsIterator();

    public abstract void goTo(long var1, @NotNull ReferenceResolution var3);

    public static /* synthetic */ void goTo$default(ObjectNavigator objectNavigator, long l, ReferenceResolution referenceResolution, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: goTo");
        }
        if ((n & 2) != 0) {
            referenceResolution = ReferenceResolution.ONLY_STRONG_REFERENCES;
        }
        objectNavigator.goTo(l, referenceResolution);
    }

    @NotNull
    public abstract ClassDefinition getClass();

    @NotNull
    public abstract LongArrayList getReferencesCopy();

    public abstract void copyReferencesTo(@NotNull LongArrayList var1);

    @NotNull
    public abstract ClassDefinition getClassForObjectId(long var1);

    @Nullable
    public abstract RootReason getRootReasonForObjectId(long var1);

    public abstract int getObjectSize();

    public abstract long getSoftReferenceId();

    public abstract long getWeakReferenceId();

    public abstract int getSoftWeakReferenceIndex();

    public final void goToInstanceField(@Nullable String className, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        long objectId = this.getInstanceFieldObjectId(className, fieldName);
        this.goTo(objectId, ReferenceResolution.ALL_REFERENCES);
    }

    public final long getInstanceFieldObjectId(@Nullable String className, @NotNull String name2) {
        int indexOfField;
        LongArrayList refs;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            refs = this.getReferencesCopy();
            if (className != null && !Intrinsics.areEqual((Object)className, (Object)this.getClass().getUndecoratedName())) {
                throw new NavigationException("Expected " + className + ", got " + this.getClass().getUndecoratedName());
            }
            List<String> $this$indexOfFirst$iv = this.getClass().allRefFieldNames(this.classStore);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<String> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                String item$iv;
                String it = item$iv = iterator2.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it, (Object)name2)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = indexOfField = -1;
        }
        if (indexOfField == -1) {
            throw new NavigationException("Missing field " + name2 + " in " + this.getClass().getName());
        }
        return refs.getLong(indexOfField);
    }

    public final void goToStaticField(@NotNull String className, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        long objectId = this.getStaticFieldObjectId(className, fieldName);
        this.goTo(objectId, ReferenceResolution.ALL_REFERENCES);
    }

    private final long getStaticFieldObjectId(String className, String fieldName) {
        StaticField staticField;
        block2: {
            StaticField[] $this$firstOrNull$iv = this.classStore.get(className).getStaticFields();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                StaticField element$iv;
                StaticField it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                staticField = element$iv;
                break block2;
            }
            staticField = null;
        }
        if (staticField == null) {
            throw new NavigationException("Missing static field " + fieldName + " in class " + className);
        }
        StaticField staticField2 = staticField;
        return staticField2.getObjectId();
    }

    public abstract boolean isNull();

    public abstract int getExtraData();

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$Companion;", "", "<init>", "()V", "createOnAuxiliaryFiles", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "auxOffsetsChannel", "Ljava/nio/channels/FileChannel;", "auxChannel", "hprofMetadata", "Lcom/android/tools/idea/diagnostics/hprof/classstore/HProfMetadata;", "instanceCount", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ObjectNavigator createOnAuxiliaryFiles(@NotNull HProfEventBasedParser parser, @NotNull FileChannel auxOffsetsChannel, @NotNull FileChannel auxChannel, @NotNull HProfMetadata hprofMetadata, long instanceCount) {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)auxOffsetsChannel, (String)"auxOffsetsChannel");
            Intrinsics.checkNotNullParameter((Object)auxChannel, (String)"auxChannel");
            Intrinsics.checkNotNullParameter((Object)hprofMetadata, (String)"hprofMetadata");
            CreateAuxiliaryFilesVisitor createAuxiliaryFilesVisitor = new CreateAuxiliaryFilesVisitor(auxOffsetsChannel, auxChannel, hprofMetadata.getClassStore(), parser);
            parser.accept(createAuxiliaryFilesVisitor, "auxFiles");
            MappedByteBuffer auxBuffer = auxChannel.map(FileChannel.MapMode.READ_ONLY, 0L, auxChannel.size());
            MappedByteBuffer auxOffsetsBuffer = auxOffsetsChannel.map(FileChannel.MapMode.READ_ONLY, 0L, auxOffsetsChannel.size());
            Long2ObjectOpenHashMap<RootReason> long2ObjectOpenHashMap = hprofMetadata.getRoots();
            Intrinsics.checkNotNull((Object)auxOffsetsBuffer);
            ByteBuffer byteBuffer = auxOffsetsBuffer;
            Intrinsics.checkNotNull((Object)auxBuffer);
            return new ObjectNavigatorOnAuxFiles(long2ObjectOpenHashMap, byteBuffer, auxBuffer, hprofMetadata.getClassStore(), instanceCount, parser.getIdSize());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$NavigationException;", "Ljava/lang/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.android.core"})
    public static final class NavigationException
    extends RuntimeException {
        public NavigationException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$ReferenceResolution;", "", "<init>", "(Ljava/lang/String;I)V", "ALL_REFERENCES", "ONLY_STRONG_REFERENCES", "STRONG_EXCLUDING_INNER_CLASS", "NO_REFERENCES", "intellij.android.core"})
    public static final class ReferenceResolution
    extends Enum<ReferenceResolution> {
        public static final /* enum */ ReferenceResolution ALL_REFERENCES = new ReferenceResolution();
        public static final /* enum */ ReferenceResolution ONLY_STRONG_REFERENCES = new ReferenceResolution();
        public static final /* enum */ ReferenceResolution STRONG_EXCLUDING_INNER_CLASS = new ReferenceResolution();
        public static final /* enum */ ReferenceResolution NO_REFERENCES = new ReferenceResolution();
        private static final /* synthetic */ ReferenceResolution[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReferenceResolution[] values() {
            return (ReferenceResolution[])$VALUES.clone();
        }

        public static ReferenceResolution valueOf(String value2) {
            return Enum.valueOf(ReferenceResolution.class, value2);
        }

        @NotNull
        public static EnumEntries<ReferenceResolution> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = referenceResolutionArray = new ReferenceResolution[]{ReferenceResolution.ALL_REFERENCES, ReferenceResolution.ONLY_STRONG_REFERENCES, ReferenceResolution.STRONG_EXCLUDING_INNER_CLASS, ReferenceResolution.NO_REFERENCES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator$RootObject;", "", "id", "", "reason", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "<init>", "(JLcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;)V", "getId", "()J", "getReason", "()Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class RootObject {
        private final long id;
        @NotNull
        private final RootReason reason;

        public RootObject(long id2, @NotNull RootReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            this.id = id2;
            this.reason = reason;
        }

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final RootReason getReason() {
            return this.reason;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final RootReason component2() {
            return this.reason;
        }

        @NotNull
        public final RootObject copy(long id2, @NotNull RootReason reason) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new RootObject(id2, reason);
        }

        public static /* synthetic */ RootObject copy$default(RootObject rootObject, long l, RootReason rootReason, int n, Object object) {
            if ((n & 1) != 0) {
                l = rootObject.id;
            }
            if ((n & 2) != 0) {
                rootReason = rootObject.reason;
            }
            return rootObject.copy(l, rootReason);
        }

        @NotNull
        public String toString() {
            return "RootObject(id=" + this.id + ", reason=" + this.reason + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.id);
            result2 = result2 * 31 + this.reason.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RootObject)) {
                return false;
            }
            RootObject rootObject = (RootObject)other;
            if (this.id != rootObject.id) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)rootObject.reason);
        }
    }
}

