/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editing.metrics.clearcut;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editing.metrics.CodeEdited;
import com.android.tools.idea.editing.metrics.CodeEditedListener;
import com.android.tools.idea.editing.metrics.Source;
import com.android.tools.idea.editing.metrics.clearcut.ClearcutCodeEditedListener;
import com.android.tools.idea.editing.metrics.clearcut.ClearcutCodeEditedListenerKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditingMetricsEvent;
import com.intellij.openapi.Disposable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u0019\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener;", "Lcom/android/tools/idea/editing/metrics/CodeEditedListener;", "Lcom/intellij/openapi/Disposable;", "windowDuration", "Lkotlin/time/Duration;", "clock", "Lkotlinx/datetime/Clock;", "<init>", "(JLkotlinx/datetime/Clock;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "()V", "J", "isDisposed", "", "window", "Lcom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener$Window;", "onCodeEdited", "", "event", "Lcom/android/tools/idea/editing/metrics/CodeEdited;", "dispose", "log", "elapsed", "log-HG0u8IE", "(Lcom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener$Window;J)V", "Window", "intellij.android.core.editing.metrics"})
public final class ClearcutCodeEditedListener
implements CodeEditedListener,
Disposable {
    private final long windowDuration;
    @NotNull
    private final Clock clock;
    private boolean isDisposed;
    @NotNull
    private Window window;

    private ClearcutCodeEditedListener(long windowDuration, Clock clock) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.windowDuration = windowDuration;
        this.clock = clock;
        this.window = new Window(this.clock.now());
    }

    public ClearcutCodeEditedListener() {
        this(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Clock)Clock.System.INSTANCE, null);
    }

    @Override
    public synchronized void onCodeEdited(@NotNull CodeEdited event) {
        int deletedChars;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isDisposed) {
            return;
        }
        Instant now = this.clock.now();
        long elapsed = this.clock.now().minus-5sfh64U(this.window.getStartTime());
        if (Duration.compareTo-LRDsOJo((long)elapsed, (long)this.windowDuration) > 0) {
            this.log-HG0u8IE(this.window, elapsed);
            double d = Duration.div-LRDsOJo((long)elapsed, (long)this.windowDuration);
            double d2 = 1.0;
            double d3 = d % d2;
            Instant newWindowStartTime = now.minus-LRDsOJo(Duration.times-UwyO8pc((long)this.windowDuration, (double)(!(d3 == 0.0) && !(Math.signum(d3) == Math.signum(d2)) ? d3 + d2 : d3)));
            this.window = new Window(newWindowStartTime);
        }
        Window $this$onCodeEdited_u24lambda_u242 = this.window;
        boolean bl = false;
        int addedChars = event.getAddedCharacterCount();
        if (addedChars > 0) {
            $this$onCodeEdited_u24lambda_u242.getCharsAdded().merge(event.getSource(), Long.valueOf(addedChars), (arg_0, arg_1) -> ClearcutCodeEditedListener.onCodeEdited$lambda$2$lambda$0(onCodeEdited.1.1.INSTANCE, arg_0, arg_1));
        }
        if ((deletedChars = event.getDeletedCharacterCount()) > 0) {
            $this$onCodeEdited_u24lambda_u242.getCharsDeleted().merge(event.getSource(), Long.valueOf(deletedChars), (arg_0, arg_1) -> ClearcutCodeEditedListener.onCodeEdited$lambda$2$lambda$1(onCodeEdited.1.2.INSTANCE, arg_0, arg_1));
        }
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        this.log-HG0u8IE(this.window, this.clock.now().minus-5sfh64U(this.window.getStartTime()));
    }

    private final void log-HG0u8IE(Window window2, long elapsed) {
        EditingMetricsEvent.Builder builder;
        AndroidStudioEvent.Builder builder2;
        if (window2.getCharsAdded().isEmpty() && window2.getCharsDeleted().isEmpty()) {
            return;
        }
        AndroidStudioEvent.Builder $this$log_HG0u8IE_u24lambda_u244 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$log_HG0u8IE_u24lambda_u244.setKind(AndroidStudioEvent.EventKind.EDITING_METRICS_EVENT);
        EditingMetricsEvent.Builder $this$log_HG0u8IE_u24lambda_u244_u24lambda_u243 = builder = $this$log_HG0u8IE_u24lambda_u244.getEditingMetricsEventBuilder();
        boolean bl2 = false;
        $this$log_HG0u8IE_u24lambda_u244_u24lambda_u243.setCharacterMetrics(window2.toCharacterMetrics-LRDsOJo(((Duration)RangesKt.coerceAtMost((Comparable)Duration.box-impl((long)elapsed), (Comparable)Duration.box-impl((long)this.windowDuration))).unbox-impl()));
        AndroidStudioEvent.Builder event = builder2;
        Intrinsics.checkNotNull((Object)event);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private static final Long onCodeEdited$lambda$2$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    private static final Long onCodeEdited$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (Long)$tmp0.invoke(p0, p1);
    }

    @TestOnly
    public /* synthetic */ ClearcutCodeEditedListener(long windowDuration, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(windowDuration, clock);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener$Window;", "", "startTime", "Lkotlinx/datetime/Instant;", "<init>", "(Lkotlinx/datetime/Instant;)V", "getStartTime", "()Lkotlinx/datetime/Instant;", "charsAdded", "", "Lcom/android/tools/idea/editing/metrics/Source;", "", "getCharsAdded", "()Ljava/util/Map;", "charsDeleted", "getCharsDeleted", "toCharacterMetrics", "Lcom/google/wireless/android/sdk/stats/EditingMetricsEvent$CharacterMetrics$Builder;", "elapsed", "Lkotlin/time/Duration;", "toCharacterMetrics-LRDsOJo", "(J)Lcom/google/wireless/android/sdk/stats/EditingMetricsEvent$CharacterMetrics$Builder;", "intellij.android.core.editing.metrics"})
    @SourceDebugExtension(value={"SMAP\nClearcutCodeEditedListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClearcutCodeEditedListener.kt\ncom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener$Window\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1869#2,2:112\n1869#2,2:114\n*S KotlinDebug\n*F\n+ 1 ClearcutCodeEditedListener.kt\ncom/android/tools/idea/editing/metrics/clearcut/ClearcutCodeEditedListener$Window\n*L\n84#1:112,2\n85#1:114,2\n*E\n"})
    private static final class Window {
        @NotNull
        private final Instant startTime;
        @NotNull
        private final Map<Source, Long> charsAdded;
        @NotNull
        private final Map<Source, Long> charsDeleted;

        public Window(@NotNull Instant startTime) {
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            this.startTime = startTime;
            this.charsAdded = new LinkedHashMap();
            this.charsDeleted = new LinkedHashMap();
        }

        @NotNull
        public final Instant getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final Map<Source, Long> getCharsAdded() {
            return this.charsAdded;
        }

        @NotNull
        public final Map<Source, Long> getCharsDeleted() {
            return this.charsDeleted;
        }

        @NotNull
        public final EditingMetricsEvent.CharacterMetrics.Builder toCharacterMetrics-LRDsOJo(long elapsed) {
            EditingMetricsEvent.CharacterMetrics.SourceCount.Builder p0;
            EditingMetricsEvent.CharacterMetrics.Builder builder;
            EditingMetricsEvent.CharacterMetrics.Builder $this$toCharacterMetrics_LRDsOJo_u24lambda_u240 = builder = EditingMetricsEvent.CharacterMetrics.newBuilder();
            boolean bl = false;
            Iterable $this$forEach$iv = ClearcutCodeEditedListenerKt.toSourceCountList(this.charsAdded);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (EditingMetricsEvent.CharacterMetrics.SourceCount.Builder)element$iv;
                boolean bl2 = false;
                $this$toCharacterMetrics_LRDsOJo_u24lambda_u240.addCharsAdded(p0);
            }
            $this$forEach$iv = ClearcutCodeEditedListenerKt.toSourceCountList(this.charsDeleted);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (EditingMetricsEvent.CharacterMetrics.SourceCount.Builder)element$iv;
                boolean bl3 = false;
                $this$toCharacterMetrics_LRDsOJo_u24lambda_u240.addCharsDeleted(p0);
            }
            $this$toCharacterMetrics_LRDsOJo_u24lambda_u240.setDurationMs(Duration.getInWholeMilliseconds-impl((long)elapsed));
            EditingMetricsEvent.CharacterMetrics.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
            return builder2;
        }
    }
}

