/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.annotations.concurrency.AnyThread;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidImportFilter
extends ImportFilter {
    @AnyThread
    public boolean shouldUseFullyQualifiedName(@NotNull PsiFile targetFile, @NotNull String classQualifiedName) {
        if (classQualifiedName.equals("android.R") || classQualifiedName.startsWith("android.R.") || classQualifiedName.equals("android.databinding.tool.util.GenerationalClassUtil.ExtensionFilter.BR")) {
            return true;
        }
        int index = classQualifiedName.lastIndexOf(46);
        if (index == classQualifiedName.length() - 2 && classQualifiedName.charAt(index + 1) == 'R') {
            String pkg = AndroidImportFilter.getApplicationPackage(targetFile);
            if (pkg != null) {
                return !AndroidImportFilter.isResourceClassReference(classQualifiedName, pkg + ".R");
            }
        } else if (index > 2 && classQualifiedName.charAt(index - 1) == 'R' && classQualifiedName.charAt(index - 2) == '.') {
            return classQualifiedName.startsWith("android.R") || ResourceType.fromClassName((String)classQualifiedName.substring(index + 1)) != null;
        }
        return false;
    }

    @Nullable
    private static String getApplicationPackage(@NotNull PsiFile targetFile) {
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)targetFile);
        if (facet != null) {
            return ProjectSystemUtil.getModuleSystem(facet).getPackageName();
        }
        return null;
    }

    private static boolean isResourceClassReference(String reference, String resourceClass) {
        return reference.equals(resourceClass) || reference.startsWith(resourceClass + ".");
    }
}

