/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Version;
import com.android.manifmerger.Actions;
import com.android.projectmodel.ExternalAndroidLibrary;
import com.android.tools.idea.editors.manifest.InjectedBuildDotGradleFile;
import com.android.tools.idea.editors.manifest.ManifestFileWithMetadata;
import com.android.tools.idea.editors.manifest.ManifestPanelToken;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016JF\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J&\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00170\u001aH\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006&"}, d2={"Lcom/android/tools/idea/editors/manifest/ManifestPanelGradleToken;", "Lcom/android/tools/idea/editors/manifest/ManifestPanelToken;", "Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystem;", "Lcom/android/tools/idea/projectsystem/GradleToken;", "<init>", "()V", "getExternalAndroidLibraryDisplayName", "", "library", "Lcom/android/projectmodel/ExternalAndroidLibrary;", "recordLocationReference", "", "record", "Lcom/android/manifmerger/Actions$Record;", "files", "", "Ljava/io/File;", "handleReferencedFiles", "", "referenced", "", "sortedFiles", "", "Lcom/android/tools/idea/editors/manifest/ManifestFileWithMetadata;", "sortedOtherFiles", "metadataForFileCreator", "Lkotlin/Function1;", "Lcom/android/ide/common/blame/SourceFilePosition;", "getMetadataForRecord", "createMetadataForFile", "file", "module", "Lcom/intellij/openapi/module/Module;", "generateMinSdkSettingRunnable", "Ljava/lang/Runnable;", "minSdk", "", "Companion", "intellij.android.projectSystem.gradle"})
public final class ManifestPanelGradleToken
implements ManifestPanelToken<GradleProjectSystem>,
GradleToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final File GRADLE_MODEL_MARKER_FILE = new File("build.gradle");

    @Override
    @NotNull
    public String getExternalAndroidLibraryDisplayName(@NotNull ExternalAndroidLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        String artifactAddress = library.getAddress();
        String componentString = StringsKt.substringBefore$default((String)artifactAddress, (char)'@', null, (int)2, null);
        Component component = Component.Companion.tryParse(componentString);
        if (component != null) {
            String groupSuffix;
            StringBuilder result2 = new StringBuilder();
            String name2 = component.getName();
            if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)"-", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)(groupSuffix = StringsKt.substringAfterLast$default((String)component.getGroup(), (char)'.', null, (int)2, null)), (Object)name2)) {
                result2.append(groupSuffix).append(':');
            }
            result2.append(name2);
            Version version2 = component.getVersion();
            if (!Intrinsics.areEqual((Object)"unspecified", (Object)version2.toString())) {
                result2.append(':').append(version2);
            }
            String string = result2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        String string = StringUtil.trimLeading((String)artifactAddress, (char)':');
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimLeading(...)");
        return string;
    }

    @Override
    public boolean recordLocationReference(@NotNull Actions.Record record, @NotNull Set<File> files2) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        if (record.getActionType() == Actions.ActionType.INJECTED) {
            files2.add(GRADLE_MODEL_MARKER_FILE);
            return true;
        }
        return false;
    }

    @Override
    public void handleReferencedFiles(@NotNull Set<? extends File> referenced, @NotNull List<ManifestFileWithMetadata> sortedFiles, @NotNull List<ManifestFileWithMetadata> sortedOtherFiles, @NotNull Function1<? super SourceFilePosition, ? extends ManifestFileWithMetadata> metadataForFileCreator) {
        Intrinsics.checkNotNullParameter(referenced, (String)"referenced");
        Intrinsics.checkNotNullParameter(sortedFiles, (String)"sortedFiles");
        Intrinsics.checkNotNullParameter(sortedOtherFiles, (String)"sortedOtherFiles");
        Intrinsics.checkNotNullParameter(metadataForFileCreator, (String)"metadataForFileCreator");
        if (referenced.contains(GRADLE_MODEL_MARKER_FILE)) {
            sortedFiles.add((ManifestFileWithMetadata)metadataForFileCreator.invoke((Object)new SourceFilePosition(GRADLE_MODEL_MARKER_FILE, SourcePosition.UNKNOWN)));
        }
    }

    @Override
    @Nullable
    public ManifestFileWithMetadata getMetadataForRecord(@NotNull Actions.Record record, @NotNull Function1<? super SourceFilePosition, ? extends ManifestFileWithMetadata> metadataForFileCreator) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter(metadataForFileCreator, (String)"metadataForFileCreator");
        return WhenMappings.$EnumSwitchMapping$0[record.getActionType().ordinal()] == 1 ? (ManifestFileWithMetadata)metadataForFileCreator.invoke((Object)new SourceFilePosition(GRADLE_MODEL_MARKER_FILE, SourcePosition.UNKNOWN)) : null;
    }

    @Override
    @Nullable
    public ManifestFileWithMetadata createMetadataForFile(@Nullable File file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (file == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)file.getAbsolutePath(), (Object)GRADLE_MODEL_MARKER_FILE.getAbsolutePath())) {
            ManifestFileWithMetadata manifestFileWithMetadata;
            VirtualFile gradleBuildFile = GradleProjectSystemUtil.getGradleBuildFile(module);
            if (gradleBuildFile != null) {
                File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)gradleBuildFile);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"virtualToIoFile(...)");
                File ioFile = file2;
                manifestFileWithMetadata = new InjectedBuildDotGradleFile(ioFile);
            } else {
                manifestFileWithMetadata = new InjectedBuildDotGradleFile(null);
            }
            return manifestFileWithMetadata;
        }
        return null;
    }

    @Override
    @Nullable
    public Runnable generateMinSdkSettingRunnable(@NotNull Module module, int minSdk) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return () -> ManifestPanelGradleToken.generateMinSdkSettingRunnable$lambda$4(module, minSdk);
    }

    @Override
    public boolean isApplicable(@NotNull AndroidProjectSystem projectSystem) {
        return GradleToken.super.isApplicable(projectSystem);
    }

    private static final void generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$1$lambda$0(ProjectBuildModel $pbm) {
        $pbm.applyChanges();
    }

    private static final void generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$1(Project $project, GradleBuildModel $gbm, ProjectBuildModel $pbm) {
        PsiFile[] psiFileArray = new PsiFile[]{$gbm.getPsiFile()};
        WriteCommandAction.runWriteCommandAction((Project)$project, (String)"Update build file minSdkVersion", null, () -> ManifestPanelGradleToken.generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$1$lambda$0($pbm), (PsiFile[])psiFileArray);
    }

    private static final void generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$2(Project $project) {
        ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
    }

    private static final void generateMinSdkSettingRunnable$lambda$4$lambda$3(Module $module, int $minSdk) {
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel pbm = projectBuildModel;
        GradleBuildModel gradleBuildModel = pbm.getModuleBuildModel($module);
        if (gradleBuildModel == null) {
            return;
        }
        GradleBuildModel gbm = gradleBuildModel;
        AndroidModelUtilsKt.android(gbm).defaultConfig().minSdkVersion().setValue($minSdk);
        ApplicationManager.getApplication().invokeAndWait(() -> ManifestPanelGradleToken.generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$1(project2, gbm, pbm));
        Runnable syncRunnable = () -> ManifestPanelGradleToken.generateMinSdkSettingRunnable$lambda$4$lambda$3$lambda$2(project2);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            syncRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(syncRunnable);
        }
    }

    private static final void generateMinSdkSettingRunnable$lambda$4(Module $module, int $minSdk) {
        Runnable linkAction = () -> ManifestPanelGradleToken.generateMinSdkSettingRunnable$lambda$4$lambda$3($module, $minSdk);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            linkAction.run();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(linkAction);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/editors/manifest/ManifestPanelGradleToken$Companion;", "", "<init>", "()V", "GRADLE_MODEL_MARKER_FILE", "Ljava/io/File;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Actions.ActionType.values().length];
            try {
                nArray[Actions.ActionType.INJECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

