/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultilineStringEditorDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JBLabel myTranslationLabel;
    private EditorTextField myDefaultTextField;
    private EditorTextField myTranslationTextField;
    private final Locale myLocale;
    private String myDefaultValue;
    private String myTranslation;

    public MultilineStringEditorDialog(@NotNull AndroidFacet facet, @NotNull String key, @Nullable String value2, @Nullable Locale locale, @Nullable String translation) {
        super(facet.getModule().getProject(), false);
        this.setupUI();
        this.myLocale = locale;
        this.myDefaultTextField.setOneLineMode(false);
        this.myTranslationTextField.setOneLineMode(false);
        this.setTitle("Key: " + key);
        if (value2 != null) {
            this.myDefaultTextField.setText(value2);
        }
        if (locale != null) {
            this.myTranslationLabel.setText("Translation for " + Locale.getLocaleLabel((Locale)locale, (boolean)false));
            this.myTranslationTextField.setEnabled(true);
            if (translation != null) {
                this.myTranslationTextField.setText(translation);
            }
        } else {
            this.myTranslationTextField.setEnabled(false);
        }
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "strings.multiline.dialog";
    }

    @NotNull
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    @NotNull
    public String getTranslation() {
        return this.myTranslation;
    }

    @Nullable
    public Locale getLocale() {
        return this.myLocale;
    }

    protected void doOKAction() {
        this.myDefaultValue = this.myDefaultTextField.getText();
        this.myTranslation = this.myTranslationTextField.getText();
        super.doOKAction();
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("Default Value:");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myDefaultTextField = new EditorTextField();
        this.myPanel.add((Component)this.myDefaultTextField, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, new Dimension(400, 150), null, null, 0, false));
        this.myTranslationLabel = new JBLabel();
        this.myTranslationLabel.setText("Translation:");
        this.myPanel.add((Component)this.myTranslationLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.myTranslationTextField = new EditorTextField();
        this.myTranslationTextField.setName("translationEditorTextField");
        this.myPanel.add((Component)this.myTranslationTextField, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, new Dimension(400, 150), null, null, 0, false));
    }
}

