/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.model.StringResourceRepository;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.PsiResourceItem;
import com.android.tools.idea.res.StringResourceWriter;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.SameThreadExecutor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u0000 ;2\u00020\u0001:\u0002:;B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001a\u001a\u00020\u00182\b\u0010\u001b\u001a\u0004\u0018\u00010\u0010J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130$2\u0006\u0010\u0019\u001a\u00020\u0018H\u0007J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u0013J\u0018\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0$2\u0006\u0010(\u001a\u00020\u0018H\u0002J\b\u0010)\u001a\u0004\u0018\u00010\u0018J\u0010\u0010*\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u0010+\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0010J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00130$2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u0018J\u0012\u0010.\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0010H\u0002J*\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0$2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00182\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u0010J\u000e\u00106\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0010J\u0010\u00107\u001a\u00020\u00132\u0006\u00108\u001a\u00020\u0000H\u0002J\b\u00109\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u00102\u001a\b\u0012\u0004\u0012\u00020\u0010038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006<"}, d2={"Lcom/android/tools/idea/editors/strings/StringResource;", "", "key", "Lcom/android/tools/idea/editors/strings/model/StringResourceKey;", "data", "Lcom/android/tools/idea/editors/strings/StringResourceData;", "stringResourceWriter", "Lcom/android/tools/idea/res/StringResourceWriter;", "<init>", "(Lcom/android/tools/idea/editors/strings/model/StringResourceKey;Lcom/android/tools/idea/editors/strings/StringResourceData;Lcom/android/tools/idea/res/StringResourceWriter;)V", "getKey", "()Lcom/android/tools/idea/editors/strings/model/StringResourceKey;", "getData", "()Lcom/android/tools/idea/editors/strings/StringResourceData;", "localeToTranslationMap", "", "Lcom/android/ide/common/resources/Locale;", "Lcom/android/tools/idea/editors/strings/StringResource$ResourceItemEntry;", "isTranslatable", "", "()Z", "setTranslatable", "(Z)V", "tentativeDefaultValue", "", "defaultValue", "getTagText", "locale", "defaultValueAsResourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "getDefaultValueAsResourceItem", "()Lcom/android/ide/common/resources/ResourceItem;", "defaultValueAsString", "getDefaultValueAsString", "()Ljava/lang/String;", "setDefaultValue", "Lcom/google/common/util/concurrent/ListenableFuture;", "changeTranslatable", "translatable", "createDefaultValue", "value", "validateDefaultValue", "getTranslationAsResourceItem", "getTranslationAsString", "putTranslation", "translation", "getAnchor", "createTranslationBefore", "anchor", "validateTranslation", "translatedLocales", "", "getTranslatedLocales", "()Ljava/util/Collection;", "isTranslationMissing", "hasSameDefaultValueFile", "other", "getDefaultValueFileName", "ResourceItemEntry", "Companion", "intellij.android.core"})
public final class StringResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringResourceKey key;
    @NotNull
    private final StringResourceData data;
    @NotNull
    private final StringResourceWriter stringResourceWriter;
    @NotNull
    private final Map<Locale, ResourceItemEntry> localeToTranslationMap;
    private boolean isTranslatable;
    @Nullable
    private String tentativeDefaultValue;
    @Nullable
    private ResourceItemEntry defaultValue;
    @NotNull
    private static final Logger LOGGER;

    public StringResource(@NotNull StringResourceKey key, @NotNull StringResourceData data2, @NotNull StringResourceWriter stringResourceWriter) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)stringResourceWriter, (String)"stringResourceWriter");
        this.key = key;
        this.data = data2;
        this.stringResourceWriter = stringResourceWriter;
        this.localeToTranslationMap = new LinkedHashMap();
        this.isTranslatable = !this.key.isFromDoNotTranslateFile();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (ResourceItem item : this.data.getRepository().getItems(this.key)) {
            Locale locale;
            XmlTag tag;
            if (!(item instanceof PsiResourceItem) && !(item instanceof DynamicValueResourceItem)) {
                LOGGER.warn(item + " has an unexpected class " + item.getClass().getName());
            }
            XmlTag xmlTag = tag = IdeResourcesUtil.getItemTag(this.data.getProject(), item);
            if (Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getAttributeValue("translatable") : null), (Object)"false")) {
                this.isTranslatable = false;
            }
            ResourceItemEntry resourceItemEntry = ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(tag));
            LocaleQualifier qualifier = item.getConfiguration().getLocaleQualifier();
            if (qualifier == null) {
                this.defaultValue = resourceItemEntry;
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)Locale.create((LocaleQualifier)qualifier), (String)"create(...)");
            this.localeToTranslationMap.put(locale, resourceItemEntry);
        }
    }

    public /* synthetic */ StringResource(StringResourceKey stringResourceKey, StringResourceData stringResourceData, StringResourceWriter stringResourceWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stringResourceWriter = StringResourceWriter.INSTANCE;
        }
        this(stringResourceKey, stringResourceData, stringResourceWriter);
    }

    @NotNull
    public final StringResourceKey getKey() {
        return this.key;
    }

    @NotNull
    public final StringResourceData getData() {
        return this.data;
    }

    public final boolean isTranslatable() {
        return this.isTranslatable;
    }

    public final void setTranslatable(boolean bl) {
        this.isTranslatable = bl;
    }

    @NotNull
    public final String getTagText(@Nullable Locale locale) {
        ResourceItemEntry resourceItemEntry = locale != null ? this.localeToTranslationMap.get(locale) : this.defaultValue;
        Object object = resourceItemEntry;
        if (object == null || (object = ((ResourceItemEntry)object).getTagText()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public final ResourceItem getDefaultValueAsResourceItem() {
        ResourceItemEntry resourceItemEntry = this.defaultValue;
        return resourceItemEntry != null ? resourceItemEntry.getResourceItem() : null;
    }

    @NotNull
    public final String getDefaultValueAsString() {
        Object object = this.defaultValue;
        if (object == null || (object = ((ResourceItemEntry)object).getString()) == null) {
            object = "";
        }
        return object;
    }

    @UiThread
    @NotNull
    public final ListenableFuture<Boolean> setDefaultValue(@NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        if (this.defaultValue == null) {
            if (Intrinsics.areEqual((Object)defaultValue, (Object)this.tentativeDefaultValue)) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
                return listenableFuture;
            }
            this.tentativeDefaultValue = defaultValue;
            ListenableFuture<ResourceItem> futureItem = this.createDefaultValue(defaultValue);
            ListenableFuture listenableFuture = Futures.transform(futureItem, arg_0 -> StringResource.setDefaultValue$lambda$1(arg_0 -> StringResource.setDefaultValue$lambda$0(this, arg_0), arg_0), (Executor)SameThreadExecutor.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
            return listenableFuture;
        }
        ResourceItemEntry resourceItemEntry = this.defaultValue;
        Intrinsics.checkNotNull((Object)resourceItemEntry);
        if (Intrinsics.areEqual((Object)resourceItemEntry.getString(), (Object)defaultValue)) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        Project project = this.data.getProject();
        ResourceItemEntry resourceItemEntry2 = this.defaultValue;
        Intrinsics.checkNotNull((Object)resourceItemEntry2);
        boolean changed = this.stringResourceWriter.setItemText(project, resourceItemEntry2.getResourceItem(), defaultValue);
        if (!changed) {
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        if (((CharSequence)defaultValue).length() == 0) {
            this.defaultValue = null;
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        ResourceItem resourceItem = this.data.getRepository().getDefaultValue(this.key);
        if (resourceItem == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        ResourceItem item = resourceItem;
        this.defaultValue = ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(IdeResourcesUtil.getItemTag(this.data.getProject(), item)));
        ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
        return listenableFuture;
    }

    public final boolean changeTranslatable(boolean translatable) {
        ResourceItem resourceItem = this.getDefaultValueAsResourceItem();
        if (resourceItem == null) {
            return false;
        }
        ResourceItem item = resourceItem;
        this.isTranslatable = translatable;
        if (!this.stringResourceWriter.setAttribute(this.data.getProject(), "translatable", translatable ? null : "false", item)) {
            return false;
        }
        this.defaultValue = ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(IdeResourcesUtil.getItemTag(this.data.getProject(), item)));
        return true;
    }

    private final ListenableFuture<ResourceItem> createDefaultValue(String value2) {
        if (((CharSequence)value2).length() == 0) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        this.stringResourceWriter.addDefault(this.data.getProject(), this.key, value2, this.isTranslatable);
        SettableFuture futureItem = SettableFuture.create();
        StringResourceRepository stringRepository = this.data.getRepository();
        stringRepository.invokeAfterPendingUpdatesFinish(this.key, () -> StringResource.createDefaultValue$lambda$2(futureItem, stringRepository, this));
        Intrinsics.checkNotNull((Object)futureItem);
        return (ListenableFuture)futureItem;
    }

    @Nullable
    public final String validateDefaultValue() {
        ResourceItemEntry localDefaultValue = this.defaultValue;
        return localDefaultValue == null ? "Key \"" + this.key.getName() + "\" is missing its default value" : (!localDefaultValue.getStringValid() ? "Invalid XML" : null);
    }

    @Nullable
    public final ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceItemEntry resourceItemEntry = this.localeToTranslationMap.get(locale);
        return resourceItemEntry != null ? resourceItemEntry.getResourceItem() : null;
    }

    @NotNull
    public final String getTranslationAsString(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Object object = this.localeToTranslationMap.get(locale);
        if (object == null || (object = ((ResourceItemEntry)object).getString()) == null) {
            object = "";
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ListenableFuture<Boolean> putTranslation(@NotNull Locale locale, @NotNull String translation) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"b/401392046");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (this.getTranslationAsResourceItem(locale) == null) {
                ListenableFuture listenableFuture = Futures.transform(this.createTranslationBefore(locale, translation, this.getAnchor(locale)), arg_0 -> StringResource.putTranslation$lambda$5$lambda$4(arg_0 -> StringResource.putTranslation$lambda$5$lambda$3(this, locale, arg_0), arg_0), (Executor)SameThreadExecutor.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"transform(...)");
                ListenableFuture listenableFuture2 = listenableFuture;
                return listenableFuture2;
            }
            if (Intrinsics.areEqual((Object)this.getTranslationAsString(locale), (Object)translation)) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
                ListenableFuture listenableFuture3 = listenableFuture;
                return listenableFuture3;
            }
            ResourceItem resourceItem = this.getTranslationAsResourceItem(locale);
            if (resourceItem == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            ResourceItem item = resourceItem;
            boolean changed = this.stringResourceWriter.setItemText(this.data.getProject(), item, translation);
            if (!changed) {
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
                ListenableFuture listenableFuture4 = listenableFuture;
                return listenableFuture4;
            }
            if (((CharSequence)translation).length() == 0) {
                this.localeToTranslationMap.remove(locale);
                ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
                Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
                ListenableFuture listenableFuture5 = listenableFuture;
                return listenableFuture5;
            }
            ResourceItem resourceItem2 = this.data.getRepository().getTranslation(this.key, locale);
            if (resourceItem2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            item = resourceItem2;
            this.localeToTranslationMap.put(locale, ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(IdeResourcesUtil.getItemTag(this.data.getProject(), item))));
            ListenableFuture listenableFuture = Futures.immediateFuture((Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            ListenableFuture listenableFuture6 = listenableFuture;
            return listenableFuture6;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final StringResourceKey getAnchor(Locale locale) {
        ResourceItem resourceItem = this.getDefaultValueAsResourceItem();
        PsiResourceItem psiResourceItem = resourceItem instanceof PsiResourceItem ? (PsiResourceItem)resourceItem : null;
        if (psiResourceItem == null) {
            return null;
        }
        PsiResourceItem item = psiResourceItem;
        XmlTag xmlTag = item.getTag();
        if (xmlTag == null) {
            return null;
        }
        XmlTag tag = xmlTag;
        XmlTag xmlTag2 = tag.getParentTag();
        if (xmlTag2 == null) {
            return null;
        }
        XmlTag resources = xmlTag2;
        Object[] objectArray = resources.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSubTags(...)");
        Object[] items = objectArray;
        int index = ArraysKt.indexOf((Object[])items, (Object)tag);
        int n = items.length;
        for (int nextIndex = index + 1; nextIndex < n; ++nextIndex) {
            String name2;
            StringResourceKey nextKey;
            StringResource nextResource;
            Object next = items[index + 1];
            if (next.getAttributeValue("name") == null || (nextResource = this.data.getStringResource(nextKey = new StringResourceKey(name2, this.key.getDirectory(), false, 4, null))).getTranslationAsResourceItem(locale) == null) continue;
            return nextKey;
        }
        return null;
    }

    private final ListenableFuture<ResourceItem> createTranslationBefore(Locale locale, String value2, StringResourceKey anchor) {
        if (((CharSequence)value2).length() == 0) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        if (this.key.getDirectory() == null) {
            ListenableFuture listenableFuture = Futures.immediateFuture(null);
            Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"immediateFuture(...)");
            return listenableFuture;
        }
        Project project = this.data.getProject();
        XmlFile file = this.data.getDefaultLocaleXml(locale);
        boolean bl = file != null ? this.stringResourceWriter.addTranslationToFile(project, file, this.key, value2, anchor) : this.stringResourceWriter.addTranslation(project, this.key, value2, locale, this.getDefaultValueFileName(), anchor);
        SettableFuture futureItem = SettableFuture.create();
        StringResourceRepository stringRepository = this.data.getRepository();
        stringRepository.invokeAfterPendingUpdatesFinish(this.key, () -> StringResource.createTranslationBefore$lambda$6(futureItem, stringRepository, this, locale));
        Intrinsics.checkNotNull((Object)futureItem);
        return (ListenableFuture)futureItem;
    }

    @Nullable
    public final String validateTranslation(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceItemEntry resourceItemEntry = this.localeToTranslationMap.get(locale);
        return (resourceItemEntry != null ? !resourceItemEntry.getStringValid() : false) ? "Invalid XML" : (this.isTranslatable && this.isTranslationMissing(locale) ? "Key \"" + this.key.getName() + "\" is missing its " + Locale.getLocaleLabel((Locale)locale, (boolean)false) + " translation" : (!this.isTranslatable && !this.isTranslationMissing(locale) ? "Key \"" + this.key.getName() + "\" is untranslatable and should not be translated to " + Locale.getLocaleLabel((Locale)locale, (boolean)false) : null));
    }

    @NotNull
    public final Collection<Locale> getTranslatedLocales() {
        return this.localeToTranslationMap.keySet();
    }

    public final boolean isTranslationMissing(@NotNull Locale locale) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ResourceItemEntry item = this.localeToTranslationMap.get(locale);
        if (StringResource.Companion.isTranslationMissing(item) && locale.hasRegion()) {
            String string = locale.qualifier.getLanguage();
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            String language = string;
            bl = StringResource.Companion.isTranslationMissing(this.localeToTranslationMap.get(Locale.create((String)language)));
        } else {
            bl = StringResource.Companion.isTranslationMissing(item);
        }
        return bl;
    }

    private final boolean hasSameDefaultValueFile(StringResource other) {
        return Intrinsics.areEqual((Object)this.getDefaultValueFileName(), (Object)other.getDefaultValueFileName());
    }

    /*
     * WARNING - void declaration
     */
    private final String getDefaultValueFileName() {
        String string;
        Object object = this.getDefaultValueAsResourceItem();
        if (object != null && (object = object.getOriginalSource()) != null && (object = object.getFileName()) != null) {
            void var1_1;
            boolean bl;
            Object fileName = object;
            boolean bl2 = false;
            boolean bl3 = bl = ((CharSequence)fileName).length() > 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            string = var1_1;
        } else {
            string = "strings.xml";
        }
        return string;
    }

    private static final Boolean setDefaultValue$lambda$0(StringResource this$0, ResourceItem item) {
        boolean bl;
        this$0.tentativeDefaultValue = null;
        if (item == null) {
            bl = false;
        } else {
            this$0.defaultValue = ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(IdeResourcesUtil.getItemTag(this$0.data.getProject(), item)));
            bl = true;
        }
        return bl;
    }

    private static final Boolean setDefaultValue$lambda$1(Function1 $tmp0, Object input2) {
        return (Boolean)$tmp0.invoke(input2);
    }

    private static final void createDefaultValue$lambda$2(SettableFuture $futureItem, StringResourceRepository $stringRepository, StringResource this$0) {
        $futureItem.set((Object)$stringRepository.getDefaultValue(this$0.key));
    }

    private static final Boolean putTranslation$lambda$5$lambda$3(StringResource this$0, Locale $locale, ResourceItem item) {
        boolean bl;
        if (item == null) {
            bl = false;
        } else {
            this$0.localeToTranslationMap.put($locale, ResourceItemEntry.Companion.create(item, StringResource.Companion.getTextOfTag(IdeResourcesUtil.getItemTag(this$0.data.getProject(), item))));
            bl = true;
        }
        return bl;
    }

    private static final Boolean putTranslation$lambda$5$lambda$4(Function1 $tmp0, Object input2) {
        return (Boolean)$tmp0.invoke(input2);
    }

    private static final void createTranslationBefore$lambda$6(SettableFuture $futureItem, StringResourceRepository $stringRepository, StringResource this$0, Locale $locale) {
        $futureItem.set((Object)$stringRepository.getTranslation(this$0.key, $locale));
    }

    static {
        Logger logger = Logger.getInstance(StringResource.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0017\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/editors/strings/StringResource$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isTranslationMissing", "", "item", "Lcom/android/tools/idea/editors/strings/StringResource$ResourceItemEntry;", "getTextOfTag", "", "Lcom/intellij/openapi/util/NlsSafe;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTranslationMissing(ResourceItemEntry item) {
            return item == null || ((CharSequence)item.getString()).length() == 0;
        }

        private final String getTextOfTag(XmlTag tag) {
            Object object = tag;
            if (object == null || (object = object.getText()) == null) {
                object = "";
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/editors/strings/StringResource$ResourceItemEntry;", "", "resourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "tagText", "", "string", "stringValid", "", "<init>", "(Lcom/android/ide/common/resources/ResourceItem;Ljava/lang/String;Ljava/lang/String;Z)V", "getResourceItem", "()Lcom/android/ide/common/resources/ResourceItem;", "getTagText", "()Ljava/lang/String;", "getString", "getStringValid", "()Z", "Companion", "intellij.android.core"})
    private static final class ResourceItemEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ResourceItem resourceItem;
        @NotNull
        private final String tagText;
        @NotNull
        private final String string;
        private final boolean stringValid;

        private ResourceItemEntry(ResourceItem resourceItem, String tagText, String string, boolean stringValid) {
            this.resourceItem = resourceItem;
            this.tagText = tagText;
            this.string = string;
            this.stringValid = stringValid;
        }

        @NotNull
        public final ResourceItem getResourceItem() {
            return this.resourceItem;
        }

        @NotNull
        public final String getTagText() {
            return this.tagText;
        }

        @NotNull
        public final String getString() {
            return this.string;
        }

        public final boolean getStringValid() {
            return this.stringValid;
        }

        public /* synthetic */ ResourceItemEntry(ResourceItem resourceItem, String tagText, String string, boolean stringValid, DefaultConstructorMarker $constructor_marker) {
            this(resourceItem, tagText, string, stringValid);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/editors/strings/StringResource$ResourceItemEntry$Companion;", "", "<init>", "()V", "create", "Lcom/android/tools/idea/editors/strings/StringResource$ResourceItemEntry;", "resourceItem", "Lcom/android/ide/common/resources/ResourceItem;", "tagText", "", "intellij.android.core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ResourceItemEntry create(@NotNull ResourceItem resourceItem, @NotNull String tagText) {
                ResourceItemEntry resourceItemEntry;
                Intrinsics.checkNotNullParameter((Object)resourceItem, (String)"resourceItem");
                Intrinsics.checkNotNullParameter((Object)tagText, (String)"tagText");
                ResourceValue value2 = resourceItem.getResourceValue();
                if (value2 == null) {
                    return new ResourceItemEntry(resourceItem, tagText, "", true, null);
                }
                String string = value2.getRawXmlValue();
                if (string == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalStateException(string2.toString());
                }
                String rawString = string;
                try {
                    String unescapedString = CharacterDataEscaper.unescape((String)rawString);
                    resourceItemEntry = new ResourceItemEntry(resourceItem, tagText, unescapedString, true, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    resourceItemEntry = new ResourceItemEntry(resourceItem, tagText, rawString, false, null);
                }
                return resourceItemEntry;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

