/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.Locale;
import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.resources.ResourceType;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.editors.strings.CopyAllSelectedAction;
import com.android.tools.idea.editors.strings.DeleteStringAction;
import com.android.tools.idea.editors.strings.GoToDeclarationAction;
import com.android.tools.idea.editors.strings.MinimumWidthTextField;
import com.android.tools.idea.editors.strings.MultilineStringEditorDialog;
import com.android.tools.idea.editors.strings.RemoveLocaleMouseListener;
import com.android.tools.idea.editors.strings.ResourceLoadingTask;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.TranslationsEditorTextField;
import com.android.tools.idea.editors.strings.action.AddKeyAction;
import com.android.tools.idea.editors.strings.action.AddLocaleAction;
import com.android.tools.idea.editors.strings.action.FilterKeysAction;
import com.android.tools.idea.editors.strings.action.FilterLocalesAction;
import com.android.tools.idea.editors.strings.action.ReloadStringResourcesAction;
import com.android.tools.idea.editors.strings.action.RemoveKeysAction;
import com.android.tools.idea.editors.strings.action.TranslationsEditorPasteAction;
import com.android.tools.idea.editors.strings.model.StringResourceKey;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableListener;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.res.StringResourceWriter;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBPanel;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class StringResourceViewPanel
implements Disposable {
    private final AndroidFacet myFacet;
    private StringResourceTable myTable;
    @Nullable
    private ActionToolbar myToolbar;
    @Nullable
    private Component myToolbarComponent;
    @Nullable
    private Component myScrollPane;
    @NotNull
    private final JComponent myXmlLabel;
    @VisibleForTesting
    final JTextComponent myXmlTextField;
    @NotNull
    private final Component myKeyLabel;
    private JTextComponent myKeyTextField;
    @NotNull
    private final Component myDefaultValueLabel;
    @VisibleForTesting
    TextFieldWithBrowseButton myDefaultValueTextField;
    @NotNull
    private final Component myTranslationLabel;
    @VisibleForTesting
    TextFieldWithBrowseButton myTranslationTextField;
    @Nullable
    private Container myPanel;
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    private GoToDeclarationAction myGoToAction;
    private DeleteStringAction myDeleteAction;
    private CopyAllSelectedAction myCopyAllAction;
    private final IdeResourceNameValidator myKeyNameValidator;
    private final Supplier<StringResourceWriter> myStringResourceWriterFactory;

    @VisibleForTesting
    StringResourceViewPanel(@NotNull AndroidFacet facet, @NotNull Disposable parentDisposable, @NotNull Supplier<StringResourceWriter> stringResourceWriterFactory) {
        this.myFacet = facet;
        this.myStringResourceWriterFactory = stringResourceWriterFactory;
        this.myKeyNameValidator = IdeResourceNameValidator.forResourceName(ResourceType.STRING);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.initTable();
        this.initToolbar();
        this.myXmlLabel = new JBLabel("XML:", 4);
        this.myXmlTextField = new MinimumWidthTextField();
        this.myXmlTextField.setEnabled(false);
        this.myXmlTextField.setName("xmlTextField");
        this.myKeyLabel = new JBLabel("Key:", 4);
        this.initKeyTextField();
        this.myDefaultValueLabel = new JBLabel("Default value:", 4);
        this.initDefaultValueTextField();
        this.myTranslationLabel = new JBLabel("Translation:", 4);
        this.initTranslationTextField();
        this.initPanel();
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 200);
        this.myLoadingPanel.setLoadingText("Loading string resource data");
        this.myLoadingPanel.setName("translationsEditor");
        this.myLoadingPanel.add((Component)this.myPanel);
        this.myLoadingPanel.startLoading();
        this.myLoadingPanel.setFocusCycleRoot(true);
        this.myLoadingPanel.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy(){

            @Override
            public Component getComponentBefore(@NotNull Container container, @NotNull Component component) {
                Component before = super.getComponentBefore(container, component);
                return StringResourceViewPanel.this.myTable.skipTransferTo(before, component) ? super.getComponentBefore(container, before) : before;
            }

            @Override
            public Component getComponentAfter(@NotNull Container container, @NotNull Component component) {
                Component after = super.getComponentAfter(container, component);
                return StringResourceViewPanel.this.myTable.skipTransferTo(after, component) ? super.getComponentAfter(container, after) : after;
            }
        });
        this.myToolbar.setTargetComponent((JComponent)this.myLoadingPanel);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            new ResourceLoadingTask(this).queue();
        }
    }

    public void addUpdateListenerToNewStringResourceModel() {
        this.myTable.getFrozenTable().getModel().addTableModelListener(e -> this.updateViewPanel());
        this.myTable.getScrollableTable().getModel().addTableModelListener(e -> this.updateViewPanel());
    }

    public Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    public void stopLoading() {
        this.myLoadingPanel.stopLoading();
        if (this.myToolbar != null) {
            ActionToolbarUtil.makeToolbarNavigable((ActionToolbar)this.myToolbar);
        }
    }

    StringResourceViewPanel(@NotNull AndroidFacet facet, @NotNull Disposable parentDisposable) {
        this(facet, parentDisposable, () -> StringResourceWriter.INSTANCE);
    }

    public void deleteSelectedKeys() {
        int modelColumn = this.myTable.getSelectedModelColumnIndex();
        if (modelColumn < 0) {
            return;
        }
        int[] selectedRows = this.myTable.getSelectedModelRows();
        if (selectedRows.length < 1) {
            return;
        }
        StringResourceTableModel model = (StringResourceTableModel)this.myTable.getModel();
        List items = Arrays.stream(selectedRows).boxed().flatMap(selectedRow -> model.getRepository().getItems(model.getKey((int)selectedRow)).stream()).toList();
        this.myStringResourceWriterFactory.get().safeDelete(this.getProject(), items, this::reloadData);
    }

    public void deleteStrings() {
        int modelColumn = this.myTable.getSelectedModelColumnIndex();
        int modelRow = this.myTable.getSelectedModelRowIndex();
        if (modelColumn < 0 || modelRow < 0) {
            return;
        }
        if (!StringResourceTableModel.isStringValueColumn(modelColumn)) {
            this.deleteSelectedKeys();
            return;
        }
        int[] selectedRows = this.myTable.getSelectedModelRows();
        if (selectedRows.length < 1) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)"Delete Strings", null, () -> Arrays.stream(selectedRows).forEach(rowIndex -> ((StringResourceTableModel)this.myTable.getModel()).setValueAt("", rowIndex, modelColumn)), (PsiFile[])new PsiFile[0]);
    }

    public void dispose() {
    }

    private void initTable() {
        this.myTable = new StringResourceTable();
        this.myDeleteAction = new DeleteStringAction(this);
        this.myGoToAction = new GoToDeclarationAction(this.getProject());
        this.myCopyAllAction = CopyAllSelectedAction.create(this.myTable);
        this.myTable.putInActionMap("delete", this.myDeleteAction);
        this.myTable.addFrozenColumnTableListener(new CellSelectionListener());
        this.myTable.addFrozenColumnTableListener(new RemoveLocaleMouseListener(this));
        final JPopupMenu menu = new JPopupMenu();
        final JMenuItem goTo = menu.add(this.myGoToAction);
        final JMenuItem delete2 = menu.add(this.myDeleteAction);
        final JMenuItem copy = menu.add(this.myCopyAllAction);
        this.myTable.addFrozenColumnTableListener(new FrozenColumnTableListener(){

            @Override
            public void cellPopupTriggered(@NotNull FrozenColumnTableEvent event) {
                StringResourceViewPanel.this.myGoToAction.update(goTo, event);
                StringResourceViewPanel.this.myDeleteAction.update(delete2, event);
                StringResourceViewPanel.this.myCopyAllAction.update(copy);
                if (goTo.isVisible() || delete2.isVisible()) {
                    Point point = event.getPoint();
                    menu.show(event.getSubcomponent(), point.x, point.y);
                }
            }
        });
        this.myScrollPane = this.myTable.getScrollPane();
    }

    private void initToolbar() {
        ActionToolbar toolbar;
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new AddKeyAction());
        group2.add((AnAction)new RemoveKeysAction());
        group2.add((AnAction)new AddLocaleAction());
        group2.add((AnAction)new FilterKeysAction());
        group2.add((AnAction)new FilterLocalesAction());
        group2.add((AnAction)new ReloadStringResourcesAction());
        group2.add((AnAction)new BrowserHelpAction("Translations editor", "https://developer.android.com/r/studio-ui/translations-editor.html"));
        this.myToolbar = toolbar = ActionManager.getInstance().createActionToolbar("TranslationsEditorToolbar", (ActionGroup)group2, true);
        this.myToolbarComponent = toolbar.getComponent();
        this.myToolbarComponent.setName("toolbar");
    }

    private void initKeyTextField() {
        this.myKeyTextField = new TranslationsEditorTextField(this.myTable, () -> 0, (Function1<? super String, String>)((Function1)this.myKeyNameValidator::getErrorText));
        this.myKeyTextField.setEnabled(false);
        this.myKeyTextField.setName("keyTextField");
    }

    private void initDefaultValueTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, () -> 3, (Function1<? super String, String>)((Function1)this::validateValue));
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myDefaultValueTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myDefaultValueTextField.setButtonIcon(StudioIcons.Common.EDIT);
        this.myDefaultValueTextField.setEnabled(false);
        this.myDefaultValueTextField.setName("defaultValueTextField");
    }

    private void initTranslationTextField() {
        TranslationsEditorTextField textField2 = new TranslationsEditorTextField(this.myTable, this.myTable::getSelectedModelColumnIndex, (Function1<? super String, String>)((Function1)this::validateValue));
        new TranslationsEditorPasteAction().registerCustomShortcutSet((JComponent)((Object)textField2), this);
        this.myTranslationTextField = new TextFieldWithBrowseButton((JTextField)((Object)textField2), (ActionListener)new ShowMultilineActionListener(), (Disposable)this);
        this.myTranslationTextField.setButtonIcon(StudioIcons.Common.EDIT);
        this.myTranslationTextField.setEnabled(false);
        this.myTranslationTextField.setName("translationTextField");
    }

    private String validateValue(@NotNull String value2) {
        try {
            CharacterDataEscaper.escape((String)value2);
            return null;
        }
        catch (IllegalArgumentException ignore) {
            return "Invalid value";
        }
    }

    private void initPanel() {
        this.myPanel = new JBPanel();
        GroupLayout layout = new GroupLayout(this.myPanel);
        layout.linkSize(0, this.myXmlLabel, this.myKeyLabel, this.myDefaultValueLabel, this.myTranslationLabel);
        layout.linkSize(1, this.myXmlLabel, this.myXmlTextField);
        layout.linkSize(1, this.myKeyLabel, this.myKeyTextField);
        layout.linkSize(1, new Component[]{this.myDefaultValueLabel, this.myDefaultValueTextField});
        layout.linkSize(1, new Component[]{this.myTranslationLabel, this.myTranslationTextField});
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addComponent(this.myToolbarComponent).addComponent(this.myScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.myXmlLabel).addComponent(this.myXmlTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myKeyLabel).addComponent(this.myKeyTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myDefaultValueLabel).addComponent((Component)this.myDefaultValueTextField)).addGroup(layout.createSequentialGroup().addComponent(this.myTranslationLabel).addComponent((Component)this.myTranslationTextField));
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.myToolbarComponent, -2, -1, -2).addComponent(this.myScrollPane).addGroup(layout.createParallelGroup().addComponent(this.myXmlLabel).addComponent(this.myXmlTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myKeyLabel).addComponent(this.myKeyTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myDefaultValueLabel).addComponent((Component)this.myDefaultValueTextField, -2, -1, -2)).addGroup(layout.createParallelGroup().addComponent(this.myTranslationLabel).addComponent((Component)this.myTranslationTextField, -2, -1, -2));
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        this.myPanel.setLayout(layout);
    }

    public void reloadData() {
        this.myLoadingPanel.setLoadingText("Updating string resource data");
        this.myLoadingPanel.startLoading();
        new ResourceLoadingTask(this).queue();
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    JBLoadingPanel getLoadingPanel() {
        return this.myLoadingPanel;
    }

    @NotNull
    public StringResourceTable getTable() {
        return this.myTable;
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myTable.getScrollableTable();
    }

    @Nullable
    @TestOnly
    public ActionToolbar getToolbar() {
        return this.myToolbar;
    }

    private void updateViewPanel() {
        if (!this.myTable.hasSelectedCell()) {
            StringResourceViewPanel.setTextAndEditable(this.myXmlTextField, "", false);
            StringResourceViewPanel.setTextAndEditable(this.myKeyTextField, "", false);
            StringResourceViewPanel.setTextAndEditable(this.myDefaultValueTextField.getTextField(), "", false);
            StringResourceViewPanel.setTextAndEditable(this.myTranslationTextField.getTextField(), "", false);
            this.myDefaultValueTextField.setButtonEnabled(false);
            this.myTranslationTextField.setButtonEnabled(false);
            return;
        }
        this.myXmlTextField.setEnabled(true);
        this.myKeyTextField.setEnabled(true);
        this.myDefaultValueTextField.setEnabled(true);
        this.myTranslationTextField.setEnabled(true);
        StringResourceTableModel model = (StringResourceTableModel)this.myTable.getModel();
        int row = this.myTable.getSelectedModelRowIndex();
        int column2 = this.myTable.getSelectedModelColumnIndex();
        Locale locale = model.getLocale(column2);
        StringResourceKey key = model.getKey(row);
        StringResourceData data2 = model.getData();
        if (data2 == null) {
            StringResourceViewPanel.setTextAndEditable(this.myXmlTextField, "", false);
        } else {
            StringResourceViewPanel.setTextAndEditable(this.myXmlTextField, data2.getStringResource(key).getTagText(locale), false);
        }
        StringResourceViewPanel.setTextAndEditable(this.myKeyTextField, key.getName(), true);
        String defaultValue = (String)model.getValueAt(row, 3);
        boolean defaultValueEditable = StringResourceViewPanel.isValueEditableInline(defaultValue);
        StringResourceViewPanel.setTextAndEditable(this.myDefaultValueTextField.getTextField(), defaultValue, defaultValueEditable);
        this.myDefaultValueTextField.setButtonEnabled(true);
        boolean translationEditable = false;
        String translation = "";
        if (locale != null) {
            translation = (String)model.getValueAt(row, column2);
            translationEditable = StringResourceViewPanel.isValueEditableInline(translation);
        }
        StringResourceViewPanel.setTextAndEditable(this.myTranslationTextField.getTextField(), translation, translationEditable);
        this.myTranslationTextField.setEnabled(locale != null);
        this.myTranslationTextField.setButtonEnabled(locale != null);
    }

    private static boolean isValueEditableInline(@NotNull String value2) {
        return !StringUtil.containsChar((String)value2, (char)'\n');
    }

    private static void setTextAndEditable(@NotNull JTextComponent component, @NotNull String text2, boolean editable) {
        component.setText(text2);
        if (!text2.equals(component.getText())) {
            component.setCaretPosition(0);
        }
        component.setEditable(editable);
        component.getCaret().setVisible(editable && component.hasFocus());
    }

    private final class CellSelectionListener
    implements FrozenColumnTableListener {
        private CellSelectionListener() {
        }

        @Override
        public void selectedCellChanged() {
            StringResourceViewPanel.this.updateViewPanel();
        }
    }

    private class ShowMultilineActionListener
    implements ActionListener {
        private ShowMultilineActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!StringResourceViewPanel.this.myTable.hasSelectedCell()) {
                return;
            }
            int row = StringResourceViewPanel.this.myTable.getSelectedModelRowIndex();
            int column2 = StringResourceViewPanel.this.myTable.getSelectedModelColumnIndex();
            StringResourceTableModel model = (StringResourceTableModel)StringResourceViewPanel.this.myTable.getModel();
            String value2 = (String)model.getValueAt(row, 3);
            Locale locale = model.getLocale(column2);
            String translation = locale == null ? null : (String)model.getValueAt(row, column2);
            MultilineStringEditorDialog d = new MultilineStringEditorDialog(StringResourceViewPanel.this.myFacet, model.getKey(row).getName(), value2, locale, translation);
            if (d.showAndGet()) {
                if (!StringUtil.equals((CharSequence)value2, (CharSequence)d.getDefaultValue())) {
                    model.setValueAt(d.getDefaultValue(), row, 3);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myDefaultValueTextField.getTextField(), d.getDefaultValue(), StringResourceViewPanel.isValueEditableInline(d.getDefaultValue()));
                }
                if (locale != null && !StringUtil.equals((CharSequence)translation, (CharSequence)d.getTranslation())) {
                    model.setValueAt(d.getTranslation(), row, column2);
                    StringResourceViewPanel.setTextAndEditable(StringResourceViewPanel.this.myTranslationTextField.getTextField(), d.getTranslation(), StringResourceViewPanel.isValueEditableInline(d.getTranslation()));
                }
            }
        }
    }
}

