/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings.table;

import com.android.ide.common.resources.escape.xml.CharacterDataEscaper;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.table.SubTable;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class StringTableCellEditor
extends DefaultCellEditor {
    private boolean myIsEditingKeyValue = false;

    StringTableCellEditor() {
        this(new JTextField());
    }

    @VisibleForTesting
    StringTableCellEditor(@NotNull JTextField component) {
        super(component);
    }

    @VisibleForTesting
    public void setCellEditorValue(@NotNull Object value2) {
        this.delegate.setValue(value2);
    }

    @Override
    public JTextComponent getComponent() {
        return (JTextComponent)this.editorComponent;
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @NotNull Object value2, boolean selected, int row, int column2) {
        JComponent component = (JComponent)super.getTableCellEditorComponent(table2, value2, selected, row, column2);
        component.setBorder(new LineBorder((Color)JBColor.BLACK));
        component.setToolTipText(null);
        this.myIsEditingKeyValue = this.isKeyColumn(table2, column2);
        return component;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            String value2 = (String)this.getCellEditorValue();
            if (this.myIsEditingKeyValue) {
                IdeResourceNameValidator nameValidator = IdeResourceNameValidator.forResourceName(ResourceType.STRING);
                String error = nameValidator.getErrorText(value2);
                if (error != null) {
                    throw new IllegalArgumentException(error);
                }
            } else {
                CharacterDataEscaper.escape((String)value2);
            }
            return super.stopCellEditing();
        }
        catch (IllegalArgumentException exception) {
            this.getComponent().setBorder(new LineBorder((Color)JBColor.RED));
            String message = this.myIsEditingKeyValue ? exception.getMessage() : "Invalid value";
            this.getComponent().setToolTipText(message);
            return false;
        }
    }

    private boolean isKeyColumn(@NotNull JTable table2, int column2) {
        if (column2 != 0) {
            return false;
        }
        if (!(table2 instanceof SubTable)) {
            return false;
        }
        SubTable subTable = (SubTable)((Object)table2);
        return subTable == subTable.getFrozenColumnTable().getFrozenTable();
    }
}

