/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidTargetData;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationSettings mySettings;
    @NotNull
    private final ResourceReference myStyleReference;

    public ThemeEditorStyle(@NotNull ConfigurationSettings settings, @NotNull ResourceReference styleReference) {
        this.mySettings = settings;
        this.myStyleReference = styleReference;
    }

    @NotNull
    public final ResourceReference getStyleReference() {
        return this.myStyleReference;
    }

    @NotNull
    public String getQualifiedName() {
        ResourceRepositoryManager repositoryManager = this.mySettings.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null || repositoryManager.getNamespace().equals((Object)this.myStyleReference.getNamespace())) {
            return this.myStyleReference.getName();
        }
        return this.myStyleReference.getQualifiedName();
    }

    @NotNull
    public String getName() {
        return this.myStyleReference.getName();
    }

    public boolean isFramework() {
        return this.myStyleReference.getNamespace().equals((Object)ResourceNamespace.ANDROID);
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ResourceRepositoryManager repositoryManager = this.mySettings.getConfigModule().getResourceRepositoryManager();
        assert (repositoryManager != null);
        ResourceRepository repository2 = repositoryManager.getProjectResources();
        return repository2.hasResources(this.myStyleReference.getNamespace(), this.myStyleReference.getResourceType(), this.myStyleReference.getName());
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target2 = this.mySettings.getTarget();
        if (target2 == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target2, this.mySettings.getConfigModule().getAndroidPlatform());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE, this.getName());
    }
}

