/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common;

import com.android.ddmlib.ClientData;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.execution.common.adb.shell.tasks.LaunchSandboxSdkKt;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.execution.common.debug.DebugSessionStarter;
import com.android.tools.idea.execution.common.debug.impl.java.AndroidJavaDebugger;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.ApplicationProjectContext;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a6\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0015"}, d2={"shouldDebugSandboxSdk", "", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "device", "Lcom/android/ddmlib/IDevice;", "state", "Lcom/android/tools/idea/execution/common/debug/AndroidDebuggerState;", "attachDebuggerToSandboxSdk", "", "applicationId", "", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "console", "Lcom/intellij/execution/ui/ConsoleView;", "(Lcom/android/ddmlib/IDevice;Ljava/lang/String;Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/execution/ui/ConsoleView;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hasDebugSandboxSdkEnabled", "hasPrivacySandboxSdk", "intellij.android.execution.common"})
public final class SandboxSdkUtilsKt {
    public static final boolean shouldDebugSandboxSdk(@NotNull ApkProvider apkProvider, @NotNull IDevice device2, @NotNull AndroidDebuggerState state2) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        return SandboxSdkUtilsKt.hasDebugSandboxSdkEnabled(state2) && device2.getVersion().isAtLeast(33) && SandboxSdkUtilsKt.hasPrivacySandboxSdk(apkProvider, device2);
    }

    @Nullable
    public static final Object attachDebuggerToSandboxSdk(@NotNull IDevice device2, @NotNull String applicationId2, @NotNull ExecutionEnvironment env, @NotNull ProgressIndicator indicator, @NotNull ConsoleView console, @NotNull Continuation<? super Unit> $completion) throws ExecutionException {
        AndroidJavaDebugger debugger = new AndroidJavaDebugger();
        Object object = DebugSessionStarter.INSTANCE.attachDebuggerToStartedProcess(device2, new ApplicationProjectContext(){

            public String getApplicationId() {
                return "com.google.android.sdksandbox";
            }
        }, env, debugger, debugger.createState(), (Function1<? super IDevice, Unit>)((Function1)arg_0 -> SandboxSdkUtilsKt.attachDebuggerToSandboxSdk$lambda$0(applicationId2, arg_0)), indicator, console, 15L, ClientData.DebuggerStatus.DEFAULT, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean hasDebugSandboxSdkEnabled(AndroidDebuggerState state2) {
        return (Boolean)StudioFlags.LAUNCH_SANDBOX_SDK_PROCESS_WITH_DEBUGGER_ATTACHED_ON_DEBUG.get() != false && state2 != null && state2.DEBUG_SANDBOX_SDK;
    }

    private static final boolean hasPrivacySandboxSdk(ApkProvider apkProvider, IDevice device2) {
        boolean bl;
        try {
            Collection<ApkInfo> collection2 = apkProvider.getApks(device2);
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"getApks(...)");
            Collection<ApkInfo> apkList = collection2;
            for (ApkInfo apk : apkList) {
                if (!apk.isSandboxApk()) continue;
                return true;
            }
            bl = false;
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException((Throwable)e);
        }
        return bl;
    }

    private static final Unit attachDebuggerToSandboxSdk$lambda$0(String $applicationId, IDevice d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        d.executeShellCommand(LaunchSandboxSdkKt.getCommandStopSdkSandbox($applicationId), (IShellOutputReceiver)new CollectingOutputReceiver());
        return Unit.INSTANCE;
    }
}

