/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.applychanges;

import com.android.tools.idea.execution.common.applychanges.BaseAction;
import com.android.tools.idea.run.util.SwapInfo;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import icons.StudioIcons;
import javax.swing.KeyStroke;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;

public class CodeSwapAction
extends BaseAction {
    public static final String ID = "android.deploy.CodeSwap";
    public static final String DISPLAY_NAME = "Apply Code Changes";
    public static final String ACCELERATOR_NAME = "Apply Cod&e Changes";
    private static final Shortcut SHORTCUT = new KeyboardShortcut(KeyStroke.getKeyStroke(SystemInfo.isMac ? "control meta shift E" : "control alt F10"), null);
    private static final String DESC = "Attempt to apply only code changes without restarting anything.";

    public CodeSwapAction() {
        super(ID, DISPLAY_NAME, ACCELERATOR_NAME, SwapInfo.SwapType.APPLY_CODE_CHANGES, StudioIcons.Shell.Toolbar.APPLY_CODE_SWAP, SHORTCUT, DESC);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        ConfigurationType type;
        String id2;
        super.update(e);
        if (!e.getPresentation().isVisible() || !e.getPresentation().isEnabled()) {
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        RunManager runManager = RunManager.getInstanceIfCreated((Project)project);
        if (runManager == null) {
            return;
        }
        RunnerAndConfigurationSettings runConfig = runManager.getSelectedConfiguration();
        if (runConfig != null && AndroidBuildCommonUtils.isTestConfiguration((String)(id2 = (type = runConfig.getType()).getId()))) {
            this.disableAction(e.getPresentation(), new BaseAction.DisableMessage(BaseAction.DisableMessage.DisableMode.DISABLED, "test project", "the selected configuration is a test configuration"));
        }
    }
}

