/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.impl.java;

import com.android.ddmlib.Client;
import com.android.tools.idea.execution.common.debug.AndroidJavaDebugEnvironment;
import com.android.tools.idea.execution.common.processhandler.AndroidRemoteDebugProcessHandler;
import com.intellij.debugger.DebuggerGlobalSearchScope;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\bH\u0016J\u000f\u0010!\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0010\u001a\t\u0018\u00010\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/execution/common/debug/impl/java/AndroidJavaDebugEnvironmentImpl;", "Lcom/android/tools/idea/execution/common/debug/AndroidJavaDebugEnvironment;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "client", "Lcom/android/ddmlib/Client;", "mySessionName", "", "consoleViewToReuse", "Lcom/intellij/execution/ui/ConsoleView;", "detachIsDefault", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/ddmlib/Client;Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleView;Z)V", "disposableProject", "runJre", "Lcom/intellij/openapi/projectRoots/Sdk;", "Lorg/jetbrains/annotations/Nullable;", "myRemoteConnection", "Lcom/intellij/execution/configurations/RemoteConnection;", "searchScope", "Lcom/intellij/debugger/DebuggerGlobalSearchScope;", "getSearchScope", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "dispose", "", "isRemote", "getRemoteConnection", "getPollTimeout", "", "getSessionName", "getRunJre", "applicationId", "getApplicationId", "()Ljava/lang/String;", "deviceSerialNumber", "getDeviceSerialNumber", "intellij.android.execution.common"})
public final class AndroidJavaDebugEnvironmentImpl
extends AndroidJavaDebugEnvironment
implements Disposable {
    @NotNull
    private final Client client;
    @NotNull
    private final String mySessionName;
    @Nullable
    private final ConsoleView consoleViewToReuse;
    private final boolean detachIsDefault;
    @Nullable
    private Project disposableProject;
    @Nullable
    private final Sdk runJre;
    @NotNull
    private final RemoteConnection myRemoteConnection;
    @NotNull
    private final DebuggerGlobalSearchScope searchScope;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String deviceSerialNumber;

    public AndroidJavaDebugEnvironmentImpl(@NotNull Project project, @NotNull Client client, @NotNull String mySessionName, @Nullable ConsoleView consoleViewToReuse, boolean detachIsDefault) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)mySessionName, (String)"mySessionName");
        this.client = client;
        this.mySessionName = mySessionName;
        this.consoleViewToReuse = consoleViewToReuse;
        this.detachIsDefault = detachIsDefault;
        Disposer.register((Disposable)((Disposable)project), (Disposable)this);
        this.disposableProject = project;
        this.runJre = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        this.myRemoteConnection = new RemoteConnection(true, "localhost", String.valueOf(this.client.getDebuggerListenPort()), false);
        this.searchScope = new DebuggerGlobalSearchScope(GlobalSearchScope.allScope((Project)project), project);
        String string = this.client.getClientData().getPackageName();
        if (string == null) {
            string = "unknown";
        }
        this.applicationId = string;
        String string2 = this.client.getDevice().getSerialNumber();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSerialNumber(...)");
        this.deviceSerialNumber = string2;
    }

    @NotNull
    public DebuggerGlobalSearchScope getSearchScope() {
        return this.searchScope;
    }

    @NotNull
    public ExecutionResult createExecutionResult() {
        Project project = this.disposableProject;
        if (project == null) {
            throw new IllegalStateException("The project is disposed and hence the debug environment is invalid");
        }
        ConsoleView consoleView = this.consoleViewToReuse;
        if (consoleView == null) {
            ConsoleView consoleView2 = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            consoleView = consoleView2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"getConsole(...)");
        }
        ConsoleView console = consoleView;
        Disposer.register((Disposable)((Disposable)project), (Disposable)((Disposable)console));
        AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(project, this.client, this.detachIsDefault);
        console.attachToProcess((ProcessHandler)debugProcessHandler);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)debugProcessHandler);
    }

    public void dispose() {
        this.disposableProject = null;
    }

    public boolean isRemote() {
        return true;
    }

    @NotNull
    public RemoteConnection getRemoteConnection() {
        return this.myRemoteConnection;
    }

    public long getPollTimeout() {
        return 0L;
    }

    @NotNull
    public String getSessionName() {
        return this.mySessionName;
    }

    @Nullable
    public Sdk getRunJre() {
        return this.runJre;
    }

    @Override
    @NotNull
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    @NotNull
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }
}

