/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.debug.utils;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0001\u001a6\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"SECONDS_BETWEEN_LOGGING_WAIT_STATUS", "", "waitForClientReadyForDebug", "Lcom/android/ddmlib/Client;", "device", "Lcom/android/ddmlib/IDevice;", "appIds", "", "", "pollTimeoutSeconds", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "waitingProcessState", "Lcom/android/ddmlib/ClientData$DebuggerStatus;", "getClientWithAppId", "appId", "lastLogTimes", "", "showError", "", "project", "Lcom/intellij/openapi/project/Project;", "e", "Lcom/intellij/execution/ExecutionException;", "sessionName", "intellij.android.execution.common"})
public final class UtilsKt {
    public static final long SECONDS_BETWEEN_LOGGING_WAIT_STATUS = 1L;

    @WorkerThread
    @NotNull
    public static final Client waitForClientReadyForDebug(@NotNull IDevice device2, @NotNull Collection<String> appIds, long pollTimeoutSeconds, @NotNull ProgressIndicator indicator, @NotNull ClientData.DebuggerStatus waitingProcessState) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter(appIds, (String)"appIds");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)waitingProcessState, (String)"waitingProcessState");
        indicator.setText("Waiting for processes " + CollectionsKt.joinToString$default((Iterable)appIds, null, null, null, (int)0, null, null, (int)63, null));
        Map lastLogTimes = new LinkedHashMap();
        Logger logger = Logger.getInstance((String)"waitForClientReadyForDebug");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        logger2.info("Waiting for clients " + appIds + " for " + pollTimeoutSeconds + " seconds");
        long startTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMillis <= TimeUnit.SECONDS.toMillis(pollTimeoutSeconds)) {
            indicator.checkCanceled();
            if (!device2.isOnline()) {
                throw new ExecutionException("Device is offline");
            }
            for (String appId : appIds) {
                Client client = UtilsKt.getClientWithAppId(device2, appId, lastLogTimes, waitingProcessState);
                if (client == null) continue;
                logger2.info(appId + " is now debuggable.");
                return client;
            }
            Uninterruptibles.sleepUninterruptibly((long)20L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (appIds.size() > 1) {
            throw new ExecutionException("Process IDs " + CollectionsKt.joinToString$default((Iterable)appIds, null, null, null, (int)0, null, null, (int)63, null) + " were not found. Aborting session.");
        }
        throw new ExecutionException("Process ID " + CollectionsKt.joinToString$default((Iterable)appIds, null, null, null, (int)0, null, null, (int)63, null) + " was not found. Aborting session.");
    }

    public static /* synthetic */ Client waitForClientReadyForDebug$default(IDevice iDevice, Collection collection2, long l, ProgressIndicator progressIndicator, ClientData.DebuggerStatus debuggerStatus, int n, Object object) throws ExecutionException {
        if ((n & 4) != 0) {
            l = 15L;
        }
        if ((n & 0x10) != 0) {
            debuggerStatus = ClientData.DebuggerStatus.WAITING;
        }
        return UtilsKt.waitForClientReadyForDebug(iDevice, collection2, l, progressIndicator, debuggerStatus);
    }

    private static final Client getClientWithAppId(IDevice device2, String appId, Map<String, Long> lastLogTimes, ClientData.DebuggerStatus waitingProcessState) {
        List<Client> clients = DeploymentApplicationService.Companion.getInstance().findClient(device2, appId);
        if (!((Collection)clients).isEmpty()) {
            int n;
            ClientData.DebuggerStatus debuggerStatus;
            Logger logger = Logger.getInstance((String)"waitForClientReadyForDebug");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            Long lastLogTime = lastLogTimes.get(appId);
            if (lastLogTime == null) {
                logger2.info("Found process " + appId + ". Waiting for it to be debuggable.");
                if (clients.size() > 1) {
                    logger2.info("Multiple clients with same application ID: " + appId);
                }
                lastLogTimes.put(appId, System.currentTimeMillis());
            } else if (System.currentTimeMillis() - lastLogTime >= TimeUnit.SECONDS.toMillis(1L)) {
                logger2.info("Still waiting for process " + appId + " to be debuggable.");
                lastLogTimes.put(appId, System.currentTimeMillis());
            }
            Client client = clients.get(0);
            ClientData.DebuggerStatus debuggerStatus2 = debuggerStatus = client.getClientData().getDebuggerConnectionStatus();
            int n2 = n = debuggerStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[debuggerStatus2.ordinal()];
            if (debuggerStatus == waitingProcessState) {
                return client;
            }
            if (n == 1) {
                Locale locale = Locale.US;
                String string = "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application";
                Object[] objectArray = new Object[]{client.getDebuggerListenPort()};
                String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                String message = string2;
                throw new ExecutionException(message);
            }
            if (n == 2) {
                throw new ExecutionException("A debugger is already attached");
            }
            return null;
        }
        return null;
    }

    public static final void showError(@NotNull Project project, @NotNull ExecutionException e, @NotNull String sessionName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        Intrinsics.checkNotNullParameter((Object)sessionName, (String)"sessionName");
        Object[] objectArray = new Object[]{sessionName};
        ExecutionUtil.handleExecutionError((Project)project, (String)"Debug", (Throwable)e, (String)ExecutionBundle.message((String)"error.running.configuration.message", (Object[])objectArray), (String)e.getMessage(), Function.identity(), null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientData.DebuggerStatus.values().length];
            try {
                nArray[ClientData.DebuggerStatus.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientData.DebuggerStatus.ATTACHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

