/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.execution.common.processhandler;

import com.android.adblib.tools.debugging.JdwpProcess;
import com.android.adblib.tools.debugging.JdwpProcessHolder;
import com.android.adblib.tools.debugging.JdwpProcessProperties;
import com.android.adblib.tools.debugging.JdwpProcessPropertiesCollectorKt;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidRemoteDebugProcessHandler
extends ProcessHandler {
    private final Project myProject;
    private final Client myClient;
    private final boolean myDetachIsDefault;

    public AndroidRemoteDebugProcessHandler(Project project, Client client, boolean detachIsDefault) {
        this.myProject = project;
        this.myClient = client;
        this.myDetachIsDefault = detachIsDefault;
    }

    public void startNotify() {
        final DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        DebugProcessListener listener2 = new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                debugProcess2.removeDebugProcessListener((DebugProcessListener)this);
                ScheduledFuture<?> future2 = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> AndroidRemoteDebugProcessHandler.this.notifyProcessDetached(), 1L, TimeUnit.SECONDS);
                Disposer.register((Disposable)AndroidRemoteDebugProcessHandler.this.myProject, () -> future2.cancel(false));
            }
        };
        debugProcess2.addDebugProcessListener(listener2);
        try {
            super.startNotify();
        }
        finally {
            if (debugProcess2.isDetached()) {
                debugProcess2.removeDebugProcessListener(listener2);
                this.notifyProcessDetached();
            }
        }
    }

    protected void destroyProcessImpl() {
        DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess2 != null) {
            debugProcess2.stop(false);
        }
        this.notifyProcessTerminated(0);
    }

    protected void detachProcessImpl() {
        DebugProcess debugProcess2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess((ProcessHandler)this);
        if (debugProcess2 != null) {
            debugProcess2.stop(false);
        }
        this.myClient.notifyVmMirrorExited();
        this.notifyProcessDetached();
    }

    public boolean detachIsDefault() {
        return this.myDetachIsDefault;
    }

    public OutputStream getProcessInput() {
        return null;
    }

    public boolean isPackageRunning(@Nullable IDevice device2, @NotNull String packageName) {
        return (device2 == null || device2 == this.myClient.getDevice()) && packageName.equals(this.myClient.getClientData().getPackageName());
    }

    @NotNull
    public IDevice getConnectedDevice() {
        return this.myClient.getDevice();
    }

    @NotNull
    public List<String> getApplicationPackageNames() {
        Client client = this.myClient;
        if (client instanceof JdwpProcessHolder) {
            JdwpProcessHolder client2 = (JdwpProcessHolder)client;
            JdwpProcess process2 = client2.getJdwpProcessValue();
            JdwpProcessProperties properties = (JdwpProcessProperties)JdwpProcessPropertiesCollectorKt.getPropertiesFlow((JdwpProcess)process2).getValue();
            if (!properties.getPackageNames().getHasValue()) {
                return Collections.emptyList();
            }
            return (List)properties.getPackageNames().getOrThrow();
        }
        String name2 = this.myClient.getClientData().getPackageName();
        if (name2 == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(name2);
    }
}

