/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags;

import com.android.tools.idea.flags.ExperimentalConfigurable;
import com.android.tools.idea.flags.ExperimentalSettingsContributor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExperimentalSettingsConfigurable
extends CompositeConfigurable<ExperimentalConfigurable>
implements SearchableConfigurable {
    private JPanel myPanel;
    private JPanel myExtensionPanel;
    private final Project myProject;
    private final SortedMap<String, ExperimentalConfigurable> myConfigurableMap = new TreeMap<String, ExperimentalConfigurable>();
    private final boolean forAndroidStudio;

    ExperimentalSettingsConfigurable(@NotNull Project project, boolean studio) {
        this.myProject = project;
        this.forAndroidStudio = studio;
        this.setupUI();
        this.reset();
    }

    @NotNull
    public String getId() {
        if (this.forAndroidStudio) {
            return "experimental";
        }
        return "experimentalPlugin";
    }

    @Nls
    public String getDisplayName() {
        if (this.forAndroidStudio) {
            return "Experimental";
        }
        return "Android (Experimental)";
    }

    @NotNull
    public List<ExperimentalConfigurable> createConfigurables() {
        for (ExperimentalSettingsContributor contributor : (ExperimentalSettingsContributor[])ExperimentalSettingsContributor.EP_NAME.getExtensions()) {
            if (!contributor.shouldCreateConfigurable(this.myProject)) continue;
            ExperimentalConfigurable configurable = contributor.createConfigurable(this.myProject);
            String name2 = contributor.getName();
            this.myConfigurableMap.put(name2, configurable);
        }
        return this.myConfigurableMap.values().stream().toList();
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @NotNull
    public JComponent createComponent() {
        this.myExtensionPanel.setLayout(new BoxLayout(this.myExtensionPanel, 3));
        this.myConfigurableMap.forEach((name2, configurable) -> {
            this.myExtensionPanel.add(new JLabel(" "));
            this.myExtensionPanel.add((Component)new TitledSeparator(name2));
            this.myExtensionPanel.add(configurable.createComponent());
        });
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        boolean shouldApply = true;
        boolean shouldAskForRestart = false;
        boolean shouldRestart = false;
        Application application = ApplicationManager.getApplication();
        for (ExperimentalConfigurable configurable : this.getConfigurables()) {
            ExperimentalConfigurable.ApplyState state2 = configurable.preApplyCallback();
            shouldApply &= state2 != ExperimentalConfigurable.ApplyState.BLOCK;
            shouldAskForRestart |= state2 == ExperimentalConfigurable.ApplyState.RESTART;
        }
        shouldAskForRestart &= !application.isUnitTestMode();
        if (!shouldApply) {
            return;
        }
        if (shouldAskForRestart) {
            String action2 = application.isRestartCapable() ? "Restart" : "Shutdown";
            int result2 = Messages.showYesNoDialog((String)"Android Studio must be restarted for changes to take effect.", (String)"Restart Required", (String)action2, (String)"Cancel", (Icon)Messages.getQuestionIcon());
            if (result2 == 0) {
                shouldRestart = true;
            } else {
                return;
            }
        }
        super.apply();
        for (ExperimentalConfigurable configurable : this.getConfigurables()) {
            configurable.postApplyCallback();
        }
        if (shouldRestart) {
            ApplicationManager.getApplication().exit(false, true, true);
        }
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        JBLabel jBLabel1 = new JBLabel();
        jBLabel1.setText("<html><b>Note:</b> These settings are for features that are considered <b>experimental</b>.</html>");
        this.myPanel.add((Component)jBLabel1, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 5, null, null, null, 0, false));
        this.myExtensionPanel = new JPanel();
        this.myExtensionPanel.setLayout(new BorderLayout(0, 0));
        this.myPanel.add((Component)this.myExtensionPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
    }
}

