/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.actions.GoToBundleLocationTask;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.project.AndroidNotification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GenerateBundleAction
extends AndroidStudioGradleAction {
    private static final String ACTION_TEXT = "Generate Bundles";

    public GenerateBundleAction() {
        super(ACTION_TEXT);
    }

    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        e.getPresentation().setEnabled(!GenerateBundleAction.isGradleSyncInProgress(project));
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        List<Module> appModules = GradleProjectSystemUtil.getAppHolderModulesSupportingBundleTask(project);
        if (!appModules.isEmpty()) {
            GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
            GoToBundleLocationTask task2 = new GoToBundleLocationTask(project, appModules, ACTION_TEXT);
            Module[] modulesToBuild = appModules.toArray(Module.EMPTY_ARRAY);
            task2.executeWhenBuildFinished(gradleBuildInvoker.bundle(modulesToBuild));
        } else {
            AndroidNotification.getInstance((Project)project).showBalloon(ACTION_TEXT, "No modules supporting bundles found", NotificationType.ERROR);
        }
    }
}

