/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.gradle.util.ui.EventUtil;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import org.jetbrains.annotations.NotNull;

public class SelectBuildVariantAction
extends AnAction {
    public SelectBuildVariantAction() {
        super("Select Build Variant...");
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (!AndroidStudioGradleAction.isGradleProject(e)) {
            return;
        }
        Project project = e.getProject();
        assert (project != null);
        this.doPerform(e, project);
    }

    public final void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(AndroidStudioGradleAction.isGradleProject(e));
    }

    private void doPerform(@NotNull AnActionEvent e, final @NotNull Project project) {
        final Module module = EventUtil.getSelectedAndroidModule(e);
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        ToolWindow toolWindow = manager.getToolWindow("Build Variants");
        if (toolWindow != null) {
            toolWindow.activate(new Runnable(){

                @Override
                public void run() {
                    BuildVariantView view = BuildVariantView.getInstance(project);
                    if (module != null) {
                        view.findAndSelectVariantEditor(module);
                    }
                }
            });
        }
    }
}

