/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.tools.idea.gradle.dependencies.DependenciesHelper;
import com.android.tools.idea.gradle.dependencies.DependenciesInserter;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.gradle.GradleModuleSystem;
import com.google.common.base.Objects;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)project.getService(GradleDependencyManager.class);
    }

    @TestOnly
    public List<Dependency> findMissingDependencies(@NotNull Module module, @NotNull Iterable<Dependency> dependencies2) {
        Project project = module.getProject();
        GradleAndroidModel gradleModel = GradleAndroidModel.get(module);
        GradleBuildModel buildModel = ProjectBuildModel.get(project).getModuleBuildModel(module);
        if (gradleModel == null && buildModel == null) {
            return Collections.emptyList();
        }
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts() : null;
        String declaredAppCompatVersion = GradleDependencyManager.getDeclaredAppCompatVersion(compileDependencies);
        ArrayList<Dependency> missingLibraries = new ArrayList<Dependency>();
        for (Dependency dependency : dependencies2) {
            if (dependency.getGroup() == null) continue;
            Optional<Dependency> resolvedCoordinate = this.resolveCoordinate(project, dependency, declaredAppCompatVersion);
            Dependency finalDependency = resolvedCoordinate.orElse(dependency);
            boolean dependencyFound = compileDependencies != null && compileDependencies.stream().anyMatch(d -> Objects.equal((Object)d.group().toString(), (Object)finalDependency.getGroup()) && d.name().forceString().equals(finalDependency.getName()));
            if (dependencyFound) continue;
            missingLibraries.add(finalDependency);
        }
        return missingLibraries;
    }

    private static String getDeclaredAppCompatVersion(List<ArtifactDependencyModel> compileDependencies) {
        String appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", (Object)dependency.group().toString()) || Objects.equal((Object)"multidex", (Object)dependency.name().forceString())) continue;
                String s = dependency.version().toString();
                if (s == null) break;
                appCompatVersion = s;
                break;
            }
        }
        return appCompatVersion;
    }

    private Optional<Dependency> resolveCoordinate(Project project, Dependency dependency, String declaredAppCompatVersion) {
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        Component resolvedComponent = manager.resolveDependency(dependency, project, null);
        String group2 = dependency.getGroup();
        if (declaredAppCompatVersion != null && "com.android.support".equals(group2) && dependency.getExplicitSingletonVersion() == null && !dependency.getName().equals("multidex")) {
            return Optional.of(new Dependency(group2, dependency.getName(), RichVersion.parse((String)declaredAppCompatVersion), null, null));
        }
        if (resolvedComponent == null) {
            return Optional.of(dependency);
        }
        return Optional.of(new Dependency(resolvedComponent.getGroup(), resolvedComponent.getName(), RichVersion.require((Version)resolvedComponent.getVersion()), null, null));
    }

    public boolean addDependencies(@NotNull Module module, @NotNull Iterable<Dependency> dependencies2) {
        return this.addDependenciesInTransaction(module, dependencies2, null);
    }

    public boolean addDependencies(@NotNull Module module, @NotNull Iterable<Dependency> dependencies2, @Nullable String configuration2) {
        return this.addDependenciesInTransaction(module, dependencies2, configuration2);
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<Dependency> dependencies2) {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(module.getProject());
        GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(module);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(projectBuildModel, buildModel, module, dependencies2);
        return true;
    }

    private boolean addDependenciesInTransaction(@NotNull Module module, @NotNull Iterable<Dependency> dependencies2, @Nullable String configuration2) {
        Project project = module.getProject();
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        GradleBuildModel buildModel = projectBuildModel.getModuleBuildModel(module);
        DependenciesInserter helper = DependenciesHelper.withModel(projectBuildModel);
        if (buildModel == null) {
            return false;
        }
        String sourceSet = KotlinFacetUtils.isMultiPlatformModule((Module)module) ? GradleModuleSystem.getGradleSourceSetName(module) : null;
        List<ArtifactDependencyModel> compileDependencies = buildModel.dependencies().artifacts();
        String declaredAppCompatVersion = GradleDependencyManager.getDeclaredAppCompatVersion(compileDependencies);
        WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
            for (Dependency dependency : dependencies2) {
                Optional<Dependency> resolvedCoordinate;
                Dependency finalDependency;
                String depString;
                String name2 = "implementation";
                if (configuration2 != null) {
                    name2 = configuration2;
                }
                if ((depString = (finalDependency = (resolvedCoordinate = this.resolveCoordinate(project, dependency, declaredAppCompatVersion)).orElse(dependency)).toIdentifier()) == null) {
                    return;
                }
                if (sourceSet != null) {
                    helper.addDependency(name2, depString, buildModel, sourceSet);
                    continue;
                }
                helper.addDependency(name2, depString, buildModel);
            }
            projectBuildModel.applyChanges();
        });
        return true;
    }

    private static void updateDependenciesInTransaction(@NotNull ProjectBuildModel projectBuildModel, @NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<Dependency> dependencies2) {
        assert (!dependencies2.isEmpty());
        Project project = module.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName(ADD_DEPENDENCY).run(() -> {
            DependenciesInserter helper = DependenciesHelper.withModel(projectBuildModel);
            for (Dependency dependency : dependencies2) {
                helper.updateDependencyVersion(dependency, buildModel);
            }
            projectBuildModel.applyChanges();
        });
    }
}

