/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.api.util;

import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.intellij.pom.java.LanguageLevel;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LanguageLevelUtil {
    @Nullable
    public static LanguageLevel parseFromGradleString(@NotNull String gradleString) {
        String digitalVersion = gradleString.startsWith("JavaVersion.VERSION_") ? gradleString.substring("JavaVersion.VERSION_".length()).replace('_', '.') : (gradleString.startsWith("VERSION_") ? gradleString.substring("VERSION_".length()).replace('_', '.') : (gradleString.startsWith("org.jetbrains.kotlin.gradle.dsl.JvmTarget.JVM_") ? gradleString.substring("org.jetbrains.kotlin.gradle.dsl.JvmTarget.JVM_".length()).replace('_', '.') : (gradleString.startsWith("JvmTarget.JVM_") ? gradleString.substring("JvmTarget.JVM_".length()).replace('_', '.') : (gradleString.startsWith("'") || gradleString.startsWith("\"") ? gradleString.substring(1, gradleString.length() - 1) : gradleString))));
        return LanguageLevel.parse((String)digitalVersion);
    }

    @NotNull
    public static Object convertToGradleString(@NotNull LanguageLevel languageLevel, @Nullable String sampleGradleString) {
        String underscoreVersion = languageLevel.name().substring("JDK_".length());
        String dotVersion = underscoreVersion.replace('_', '.');
        if (sampleGradleString != null) {
            if (sampleGradleString.startsWith("JavaVersion.VERSION_")) {
                return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("VERSION_")) {
                return new RawText("VERSION_" + underscoreVersion, "VERSION_" + underscoreVersion);
            }
            if (sampleGradleString.startsWith("'")) {
                return "'" + dotVersion + "'";
            }
            if (sampleGradleString.startsWith("\"")) {
                return "\"" + dotVersion + "\"";
            }
            try {
                return new BigDecimal(dotVersion);
            }
            catch (NumberFormatException e) {
                return dotVersion;
            }
        }
        return new RawText("JavaVersion.VERSION_" + underscoreVersion, "JavaVersion.VERSION_" + underscoreVersion);
    }

    @Nullable
    public static String getStringToParse(ResolvedPropertyModel model) {
        return switch (model.getValueType()) {
            case GradlePropertyModel.ValueType.BIG_DECIMAL, GradlePropertyModel.ValueType.INTEGER, GradlePropertyModel.ValueType.REFERENCE, GradlePropertyModel.ValueType.CUSTOM -> model.toString();
            case GradlePropertyModel.ValueType.STRING -> "'" + model.toString() + "'";
            default -> null;
        };
    }
}

