/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleDeclarativeBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleDeclarativeSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.GradleVersionCatalogsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.GradleDeclarativeBuildModelProvider;
import com.android.tools.idea.gradle.dsl.model.GradleDeclarativeSettingsModelProvider;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleVersionCatalogsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleVersionCatalogFile;
import com.android.tools.idea.gradle.feature.flags.DeclarativeStudioSupport;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    public ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file, @NotNull BuildModelContext buildModelContext) {
        this.myBuildModelContext = buildModelContext;
        this.myProjectBuildFile = this.myBuildModelContext.initializeContext(project, file);
    }

    @Override
    @NotNull
    public BuildModelContext getContext() {
        return this.myBuildModelContext;
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : GradleModelFactory.createGradleBuildModel(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(module);
        return file == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(modulePath);
        return file == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull Module module) {
        if (!DeclarativeStudioSupport.isEnabled()) {
            return null;
        }
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(module);
        return file == null ? null : this.getDeclarativeModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull File modulePath) {
        if (!DeclarativeStudioSupport.isEnabled()) {
            return null;
        }
        VirtualFile file = this.myBuildModelContext.getGradleBuildFile(modulePath);
        return file == null ? null : this.getDeclarativeModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleDeclarativeBuildModel getDeclarativeModuleBuildModel(@NotNull VirtualFile file) {
        if (!DeclarativeStudioSupport.isEnabled()) {
            return null;
        }
        if (!file.getName().equals("build.gradle.dcl")) {
            return null;
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return GradleDeclarativeBuildModelProvider.EP.getExtensionList().stream().map(provider -> provider.createModel(dslFile)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file, false);
        return GradleModelFactory.createGradleBuildModel(dslFile);
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Override
    @Nullable
    public GradleDeclarativeSettingsModel getDeclarativeSettingsModel() {
        if (!DeclarativeStudioSupport.isEnabled()) {
            return null;
        }
        VirtualFile virtualFile = this.getProjectSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        if (!virtualFile.getName().equals("settings.gradle.dcl")) {
            return null;
        }
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(virtualFile);
        return GradleDeclarativeSettingsModelProvider.EP.getExtensionList().stream().map(provider -> provider.createModel(settingsFile)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private VirtualFile getProjectSettingsFile() {
        VirtualFile virtualFile = this.myProjectBuildFile == null ? this.myBuildModelContext.getProjectSettingsFile() : this.myProjectBuildFile.tryToFindSettingsFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    @Override
    public void applyChanges() {
        this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        });
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        List<GradleDslFile> files2 = this.myBuildModelContext.getAllRequestedFiles();
        files2.forEach(GradleDslFile::reparse);
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels() {
        return this.getAllIncludedBuildModels((i, j) -> {});
    }

    @Override
    @NotNull
    public List<GradleBuildModel> getAllIncludedBuildModels(@NotNull BiConsumer<Integer, Integer> func) {
        GradleSettingsModel settingsModel;
        File buildSrc;
        VirtualFile buildSrcVirtualFile;
        Integer[] nModelsSeen = new Integer[]{0};
        ArrayList<GradleBuildModel> allModels = new ArrayList<GradleBuildModel>();
        if (this.myProjectBuildFile != null) {
            allModels.add(GradleModelFactory.createGradleBuildModel(this.myProjectBuildFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((buildSrcVirtualFile = this.myBuildModelContext.getGradleBuildFile(buildSrc = new File(FileUtil.toCanonicalPath((String)Optional.ofNullable(this.myBuildModelContext.getProject().getBasePath()).orElse("")), "buildSrc"))) != null) {
            allModels.add(this.getModuleBuildModel(buildSrcVirtualFile));
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], null);
        }
        if ((settingsModel = this.getProjectSettingsModel()) == null) {
            return allModels;
        }
        Set<String> modulePaths = settingsModel.modulePaths();
        Integer nModelsToConsider = nModelsSeen[0] + modulePaths.size();
        allModels.addAll(modulePaths.stream().map(modulePath -> {
            VirtualFile file;
            File moduleDir;
            GradleBuildModel model = null;
            if (!modulePath.equals(":") && (moduleDir = settingsModel.moduleDirectory((String)modulePath)) != null && (file = this.myBuildModelContext.getGradleBuildFile(moduleDir)) != null) {
                model = this.getModuleBuildModel(file);
            }
            nModelsSeen[0] = nModelsSeen[0] + 1;
            func.accept(nModelsSeen[0], nModelsToConsider);
            return model;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        return allModels;
    }

    @Override
    @NotNull
    public GradleVersionCatalogsModel getVersionCatalogsModel() {
        Set<GradleVersionCatalogFile> files2 = this.getContext().getVersionCatalogFiles();
        return new GradleVersionCatalogsModelImpl(files2, this.myBuildModelContext);
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }
}

