/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformModuleDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ScriptDependenciesModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.MapMethodTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgToMapTransform;
import com.android.tools.idea.gradle.dsl.model.ext.transforms.SingleArgumentMethodTransform;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptModuleDependencyModelImpl
extends DependencyModelImpl
implements ModuleDependencyModel {
    @NonNls
    public static final String PROJECT = "project";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String CONFIGURATION = "configuration";
    @NotNull
    private GradleDslMethodCall myDslElement;

    @Nullable
    static ModuleDependencyModel create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall, @NotNull DependencyModelImpl.Maintainer maintainer, @Nullable String platformMethodName) {
        if (PROJECT.equals(methodCall.getMethodName())) {
            if (platformMethodName != null) {
                return new PlatformModuleDependencyModelImpl(configurationName, methodCall, maintainer, platformMethodName);
            }
            return new ScriptModuleDependencyModelImpl(configurationName, methodCall, maintainer);
        }
        return null;
    }

    @NotNull
    static ModuleDependencyModel createNew(@NotNull GradlePropertiesDslElement parent, @NotNull String configurationName, @NotNull String path, @Nullable String config) {
        GradleNameElement name2 = GradleNameElement.create(configurationName);
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)parent, name2, PROJECT);
        if (config == null) {
            GradleDslLiteral pathLiteral = new GradleDslLiteral(methodCall.getArgumentsElement(), GradleNameElement.empty());
            pathLiteral.setValue(path);
            methodCall.addNewArgument(pathLiteral);
        } else {
            GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, GradleNameElement.empty());
            mapArguments.setNewLiteral(PATH, path);
            mapArguments.setNewLiteral(CONFIGURATION, config);
            methodCall.addNewArgument(mapArguments);
        }
        parent.setNewElement(methodCall);
        return new ScriptModuleDependencyModelImpl(configurationName, methodCall, ScriptDependenciesModelImpl.Maintainers.SINGLE_ITEM_MAINTAINER);
    }

    ScriptModuleDependencyModelImpl(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull DependencyModelImpl.Maintainer maintainer) {
        super(configurationName, maintainer);
        this.myDslElement = dslElement;
    }

    @Override
    @NotNull
    protected GradleDslMethodCall getDslElement() {
        return this.myDslElement;
    }

    @Override
    void setDslElement(@NotNull GradleDslElement dslElement) {
        this.myDslElement = (GradleDslMethodCall)dslElement;
    }

    @Override
    @NotNull
    public String name() {
        List pathSegments = Splitter.on((String)":").omitEmptyStrings().splitToList((CharSequence)this.path().forceString());
        int segmentCount = pathSegments.size();
        return segmentCount > 0 ? (String)pathSegments.get(segmentCount - 1) : "";
    }

    @Override
    @NotNull
    public ResolvedPropertyModel path() {
        return GradlePropertyModelBuilder.create(this.myDslElement).addTransform(new MapMethodTransform(PROJECT, PATH)).addTransform(new SingleArgumentMethodTransform(PROJECT)).buildResolved();
    }

    @Override
    @NotNull
    public ResolvedPropertyModel configuration() {
        return GradlePropertyModelBuilder.create(this.myDslElement).addTransform(new SingleArgToMapTransform(PATH, CONFIGURATION)).addTransform(new MapMethodTransform(PROJECT, CONFIGURATION)).buildResolved();
    }
}

