/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.apply;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleScriptFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyDslElement
extends GradlePropertiesDslElement {
    @NonNls
    public static final String APPLY_BLOCK_NAME = "apply";
    @NonNls
    private static final String FROM = "from";
    @NotNull
    private final List<GradleScriptFile> myAppliedDslFiles = new ArrayList<GradleScriptFile>();

    public ApplyDslElement(@NotNull GradleDslElement parent, @NotNull GradleScriptFile buildFile) {
        super(parent, null, GradleNameElement.create(APPLY_BLOCK_NAME));
        buildFile.registerApplyElement(this);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        String fileName;
        GradleDslSimpleExpression from2 = ApplyDslElement.extractFrom(element);
        if (from2 != null && (fileName = ApplyDslElement.attemptToExtractFileName(from2)) != null) {
            VirtualFile file;
            File realFile = new File(fileName);
            if (realFile.exists() && realFile.isAbsolute()) {
                file = LocalFileSystem.getInstance().findFileByIoFile(realFile);
            } else {
                VirtualFile parsingRoot = this.getDslFile().getContext().getCurrentParsingRoot();
                parsingRoot = parsingRoot == null ? this.getDslFile().getFile().getParent() : parsingRoot.getParent();
                file = VirtualFileManager.getInstance().findFileByUrl(String.valueOf(parsingRoot) + "/" + fileName);
            }
            if (file != null) {
                GradleBuildFile buildFile = this.getDslFile().getContext().getOrCreateBuildFile(file, true);
                this.myAppliedDslFiles.add(buildFile);
                if (this.myParent instanceof GradlePropertiesDslElement) {
                    ((GradlePropertiesDslElement)this.myParent).addAppliedModelProperties(buildFile);
                }
            }
        }
        super.addParsedElement(element);
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return this.myParent == null ? null : this.myParent.getPsiElement();
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.myParent == null ? null : this.myParent.create();
    }

    @Override
    public void setPsiElement(@Nullable PsiElement psiElement) {
    }

    @NotNull
    public List<GradleScriptFile> getAppliedDslFiles() {
        return this.myAppliedDslFiles;
    }

    @Nullable
    private static String attemptToExtractFileName(@NotNull GradleDslSimpleExpression element) {
        return element.getValue(String.class);
    }

    @Nullable
    private static GradleDslSimpleExpression extractFrom(@NotNull GradleDslElement element) {
        if (element instanceof GradleDslExpressionMap) {
            return ((GradleDslExpressionMap)element).getPropertyElement(FROM, GradleDslSimpleExpression.class);
        }
        if (element instanceof GradleDslMethodCall) {
            return ((GradleDslMethodCall)element).getArgumentsElement().getPropertyElement(FROM, GradleDslSimpleExpression.class);
        }
        return null;
    }
}

