/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelEffectDescription;
import com.android.tools.idea.gradle.dsl.parser.semantics.ModelSemanticsDescription;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleDslExpressionList
extends GradlePropertiesDslElement
implements GradleDslExpression {
    private static final Logger LOG = Logger.getInstance(GradleDslExpressionList.class);
    private final boolean myAppendToArgumentListWithOneElement;
    private boolean myShouldBeDeleted;
    private boolean myIsLiteralList;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2, boolean isLiteralList) {
        super(parent, null, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, boolean isLiteralList, @NotNull GradleNameElement name2) {
        super(parent, psiElement, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = isLiteralList;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name2, boolean appendToArgumentListWithOneElement) {
        super(parent, psiElement, name2);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
        this.myIsLiteralList = false;
    }

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull GradleNameElement name2) {
        super(parent, null, name2);
        this.myAppendToArgumentListWithOneElement = false;
        this.myIsLiteralList = false;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        super.addParsedElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression) {
        this.setNewElement(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression, int index) {
        this.addNewElementAt(index, expression);
    }

    public void removeElement(@NotNull GradleDslElement element) {
        super.removeProperty(element);
    }

    public GradleDslExpression getElementAt(int index) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index < 0 || index > expressions.size()) {
            return null;
        }
        return expressions.get(index);
    }

    public int findIndexOf(@NotNull GradleDslElement element) {
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        for (int i = 0; i < expressions.size(); ++i) {
            if (!expressions.get(i).equals(element)) continue;
            return i;
        }
        return -1;
    }

    public void replaceExpression(@NotNull GradleDslExpression oldExpression, @NotNull GradleDslExpression newExpression) {
        super.replaceElement(oldExpression, newExpression);
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        return this.getPropertyElements(GradleDslExpression.class);
    }

    @NotNull
    public List<GradleDslSimpleExpression> getSimpleExpressions() {
        return this.getExpressions().stream().filter(e -> e instanceof GradleDslSimpleExpression).map(e -> (GradleDslSimpleExpression)e).collect(Collectors.toList());
    }

    @NotNull
    public <T> List<T> getLiterals(@NotNull Class<T> clazz2) {
        return this.getSimpleExpressions().stream().map(e -> e.getValue(clazz2)).filter(e -> e != null).collect(Collectors.toList());
    }

    public boolean isLiteralList() {
        return this.myIsLiteralList;
    }

    public boolean isAppendToArgumentListWithOneElement() {
        return this.myAppendToArgumentListWithOneElement;
    }

    @Override
    @Nullable
    public PsiElement create() {
        return this.getDslFile().getWriter().createDslExpressionList(this);
    }

    @Override
    public void delete() {
        this.myShouldBeDeleted = true;
        super.delete();
    }

    @Override
    protected void apply() {
        this.getDslFile().getWriter().applyDslExpressionList(this);
        ModelEffectDescription effect = this.getModelEffect();
        if (effect != null && effect.semantics == ModelSemanticsDescription.CREATE_WITH_VALUE && this.isStructurallyModified()) {
            this.deleteAndRecreate();
        } else {
            super.apply();
        }
    }

    @Override
    @Nullable
    public PsiElement getExpression() {
        return this.getPsiElement();
    }

    public boolean shouldBeDeleted() {
        return !this.isLiteralList() || this.myShouldBeDeleted;
    }

    @Override
    @NotNull
    public List<GradleReferenceInjection> getResolvedVariables() {
        return ContainerUtil.filter(this.getDependencies(), e -> e.isResolved());
    }

    @Override
    public void setParsedElement(@NotNull GradleDslElement element) {
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.setParsedElement(element);
    }

    @Override
    public void addParsedElement(@NotNull GradleDslElement element) {
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.addParsedElement(element);
    }

    @Override
    public void addToParsedExpressionList(@NotNull String property2, @NotNull GradleDslElement element) {
        if (!(element instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(element)));
            return;
        }
        super.addToParsedExpressionList(property2, element);
    }

    @Override
    public void setNewElement(@NotNull GradleDslElement newElement) {
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(newElement)));
            return;
        }
        super.setNewElement(newElement);
    }

    @Override
    public void addNewElementAt(int index, @NotNull GradleDslElement newElement) {
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression: " + String.valueOf(newElement)));
            return;
        }
        List<GradleDslExpression> expressions = this.getPropertyElements(GradleDslExpression.class);
        if (index > expressions.size()) {
            LOG.warn((Throwable)new IndexOutOfBoundsException(index + " is out of bounds for size " + expressions.size()));
            return;
        }
        super.addNewElementAt(index, newElement);
    }

    @Override
    public void replaceElement(@NotNull GradleDslElement oldElement, @NotNull GradleDslElement newElement) {
        if (!(oldElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (old): " + String.valueOf(oldElement)));
            return;
        }
        if (!(newElement instanceof GradleDslExpression)) {
            LOG.warn((Throwable)new IllegalArgumentException("Not an expression (new): " + String.valueOf(newElement)));
            return;
        }
        super.replaceElement(oldElement, newElement);
    }

    @Override
    @NotNull
    public GradleDslExpressionList copy() {
        GradleDslExpressionList listClone = new GradleDslExpressionList(this.myParent, GradleNameElement.copy(this.myName), false);
        for (GradleDslElement element : this.getCurrentElements()) {
            GradleDslExpression sourceExpression = (GradleDslExpression)element;
            GradleDslExpression copiedExpression = sourceExpression.copy();
            listClone.setNewElement(copiedExpression);
        }
        return listClone;
    }
}

