/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleVersionCatalogFile
extends GradleDslFile {
    @NotNull
    private final String catalogName;

    GradleVersionCatalogFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull String catalogName, @NotNull BuildModelContext context) {
        super(file, project, moduleName, context);
        this.catalogName = catalogName;
    }

    @NotNull
    public String getCatalogName() {
        return this.catalogName;
    }

    @Override
    public void parse() {
        this.myGradleDslParser.parse();
    }

    public List<GradleReferenceInjection> getInjection(GradleDslSimpleExpression expression, PsiElement psiElement) {
        GradleDslElement targetProperty;
        String targetName;
        ArrayList<GradleReferenceInjection> result2 = new ArrayList<GradleReferenceInjection>();
        GradleDslExpressionMap versions2 = this.getPropertyElement(GradleDslExpressionMap.VERSIONS);
        if (versions2 != null && expression.isReference() && expression instanceof GradleDslVersionLiteral && (targetName = expression.getValue(String.class)) != null && (targetProperty = versions2.getPropertyElement(targetName)) != null) {
            GradleReferenceInjection injection = new GradleReferenceInjection(expression, targetProperty, psiElement, targetName);
            result2.add(injection);
        }
        return result2;
    }

    public static class GradleDslVersionLiteral
    extends GradleDslLiteral {
        private boolean ref;
        private boolean initialRef;

        public GradleDslVersionLiteral(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name2, @NotNull PsiElement literal, @NotNull GradleDslLiteral.LiteralType literalType) {
            super(parent, psiElement, name2, literal, literalType);
            this.initialRef = this.ref = literalType == GradleDslLiteral.LiteralType.REFERENCE;
        }

        public GradleDslVersionLiteral(@NotNull GradleDslElement parent, @NotNull GradleNameElement name2, @NotNull Class<?> valueClass) {
            super(parent, name2);
            this.initialRef = this.ref = ReferenceTo.class.isAssignableFrom(valueClass);
        }

        @Override
        public boolean isReference() {
            return this.ref;
        }

        @Override
        public void setValue(@NotNull Object value2) {
            if (value2 instanceof ReferenceTo) {
                if (this.isReference()) {
                    this.deleteOldDependencies();
                }
                GradleDslElement referredElement = ((ReferenceTo)value2).getReferredElement();
                super.setValue(referredElement.getName());
                this.setupNewDependency(referredElement);
                this.ref = true;
                return;
            }
            super.setValue(value2);
            this.ref = false;
        }

        private void deleteOldDependencies() {
            this.myDependencies.forEach(e -> {
                if (e.getToBeInjected() != null) {
                    e.getToBeInjected().unregisterDependent((GradleReferenceInjection)e);
                }
            });
            this.myDependencies.clear();
        }

        private void setupNewDependency(GradleDslElement targetVersion) {
            if (this.getCurrentElement() != null) {
                GradleReferenceInjection injection = new GradleReferenceInjection(this, targetVersion, this.getCurrentElement(), targetVersion.getName());
                targetVersion.registerDependent(injection);
                this.addDependency(injection);
            }
        }

        @Override
        @Nullable
        public PsiElement create() {
            PsiElement psiElement;
            GradleNameElement name2 = this.getNameElement();
            if (this.getPsiElement() == null) {
                this.initialRef = this.ref;
            }
            if (this.ref && this.getPsiElement() == null) {
                this.setNameElement(GradleNameElement.create("version.ref"));
            }
            if ((psiElement = super.create()) != null) {
                this.setNameElement(GradleNameElement.from(psiElement.getParent().getFirstChild().getFirstChild(), this.getDslFile().getParser()));
            } else {
                this.setNameElement(name2);
            }
            return psiElement;
        }

        @Override
        protected void apply() {
            if (this.ref != this.initialRef) {
                this.delete();
                this.setPsiElement(null);
                this.create();
            }
            super.apply();
        }

        @Override
        public void delete() {
            if (this.getPsiElement() != null && this.getNameElement().getNamedPsiElement() != null) {
                this.setPsiElement(this.getNameElement().getNamedPsiElement());
            }
            super.delete();
        }
    }

    public static class GradleBundleRefLiteral
    extends GradleDslLiteral {
        public GradleBundleRefLiteral(@NotNull GradleDslElement parent, @NotNull GradleNameElement name2) {
            super(parent, name2);
        }

        public GradleBundleRefLiteral(@NotNull GradleDslElement parent, @NotNull PsiElement psiElement, @NotNull GradleNameElement name2, @NotNull PsiElement literal, @NotNull GradleDslLiteral.LiteralType literalType) {
            super(parent, psiElement, name2, literal, literalType);
        }
    }
}

