/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.semantics;

import com.android.tools.idea.gradle.dsl.parser.semantics.AndroidGradlePluginVersion;
import com.android.tools.idea.gradle.dsl.parser.semantics.VersionInterval;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionConstraint {
    @Nullable
    private List<VersionInterval> agpVersion = null;

    VersionConstraint() {
    }

    public static VersionConstraint agpBefore(@NotNull AndroidGradlePluginVersion agpVersion) {
        VersionConstraint versionConstraint = new VersionConstraint();
        versionConstraint.agpVersion = Collections.singletonList(new VersionInterval(null, agpVersion));
        return versionConstraint;
    }

    public static VersionConstraint agpBefore(@NotNull String agpVersion) {
        return VersionConstraint.agpBefore(AndroidGradlePluginVersion.Companion.parse(agpVersion));
    }

    public static VersionConstraint agpFrom(@NotNull AndroidGradlePluginVersion agpVersion) {
        VersionConstraint versionConstraint = new VersionConstraint();
        versionConstraint.agpVersion = Collections.singletonList(new VersionInterval(agpVersion, null));
        return versionConstraint;
    }

    public static VersionConstraint agpFrom(@NotNull String agpVersion) {
        return VersionConstraint.agpFrom(AndroidGradlePluginVersion.Companion.parse(agpVersion));
    }

    public boolean isOkWith(@Nullable AndroidGradlePluginVersion agpVersion) {
        if (this.agpVersion == null) {
            return true;
        }
        for (VersionInterval interval : this.agpVersion) {
            if (!interval.contains(agpVersion)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionConstraint that = (VersionConstraint)o;
        return Objects.equals(this.agpVersion, that.agpVersion);
    }

    public int hashCode() {
        return Objects.hash(this.agpVersion);
    }
}

