/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.filters;

import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleExecutionConsoleManager;
import org.jetbrains.plugins.gradle.execution.filters.GradleReRunBuildFilter;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class AndroidGradleExecutionConsoleManager
extends GradleExecutionConsoleManager {
    public static final Key<String[]> EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY = Key.create((String)"extra.gradle.command.line.options");

    public boolean isApplicableFor(@NotNull ExternalSystemTask task2) {
        return GradleConstants.SYSTEM_ID.equals((Object)task2.getId().getProjectSystemId()) && task2 instanceof ExternalSystemResolveProjectTask;
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        if (task2 instanceof ExternalSystemResolveProjectTask) {
            ConsoleView executionConsole = TextConsoleBuilderFactory.getInstance().createBuilder(project).getConsole();
            executionConsole.attachToProcess(processHandler);
            executionConsole.addMessageFilter((Filter)new AndroidReRunSyncFilter(((ExternalSystemResolveProjectTask)task2).getExternalProjectPath()));
            return executionConsole;
        }
        return super.attachExecutionConsole(project, task2, env, processHandler);
    }

    public AnAction[] getCustomContextActions(@NotNull Project project, @NotNull ExternalSystemTask task2, @Nullable ExecutionEnvironment env) {
        AnAction[] contextActions = super.getCustomContextActions(project, task2, env);
        AnAction[] extendedActions = new AnAction[contextActions.length + 1];
        System.arraycopy(contextActions, 0, extendedActions, 0, contextActions.length);
        extendedActions[contextActions.length] = ActionManager.getInstance().getAction("Android.BuildTree.AdditionalActions");
        return extendedActions;
    }

    static class AndroidReRunSyncFilter
    extends GradleReRunBuildFilter {
        AndroidReRunSyncFilter(@NotNull String projectPath) {
            super(projectPath);
        }

        @NotNull
        protected HyperlinkInfo getHyperLinkInfo(@NotNull List<String> options) {
            return project -> {
                project.putUserData(EXTRA_GRADLE_COMMAND_LINE_OPTIONS_KEY, (Object)options.toArray(new String[0]));
                GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_REQUEST_RERUN_WITH_ADDITIONAL_OPTIONS), null);
            };
        }
    }
}

