/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.annotations.concurrency.AnyThread;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncNeededReason;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.GradleSyncStateHolder;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildContentManager;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
implements DumbAware,
EditorNotificationProvider {
    @NotNull
    private final AndroidProjectSystem myProjectSystem;
    @NotNull
    private final GradleSyncState mySyncState;
    private static final long HIDE_ACTION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(30L);
    private static final Set<String> DEFAULT_GRADLE_BUILD_FILE_NAMES = Set.of("build.gradle", "build.gradle.kts", "build.gradle.dcl");
    private static final Set<String> GRADLE_SETTINGS_FILE_NAMES = Set.of("settings.gradle", "settings.gradle.kts", "settings.gradle.dcl");

    public ProjectSyncStatusNotificationProvider(@NotNull Project project) {
        this(ProjectSystemUtil.getProjectSystem(project), GradleSyncState.getInstance(project));
    }

    @NonInjectable
    public ProjectSyncStatusNotificationProvider(@NotNull AndroidProjectSystem projectSystem, @NotNull GradleSyncState syncState) {
        this.myProjectSystem = projectSystem;
        this.mySyncState = syncState;
    }

    @AnyThread
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        return newPanelType.getProvider(project, file, this.mySyncState.getSyncNeededReason());
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!(this.myProjectSystem instanceof GradleProjectSystem) || ProjectSyncStatusNotificationProvider.shouldHideBanner()) {
            return NotificationPanel.Type.NONE;
        }
        if (this.mySyncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (this.mySyncState.lastSyncFailed()) {
            return NotificationPanel.Type.FAILED;
        }
        if (this.mySyncState.isSyncNeeded() == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        return NotificationPanel.Type.PROJECT_STRUCTURE;
    }

    public static boolean shouldHideBanner() {
        String lastHiddenValue;
        long lastHidden;
        long now = System.currentTimeMillis();
        return now - (lastHidden = Long.parseLong(lastHiddenValue = PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_HIDE_ACTION_TIMESTAMP", "0"))) < HIDE_ACTION_TIMEOUT_MS;
    }

    private static boolean isDefaultGradleBuildFile(VirtualFile file) {
        return DEFAULT_GRADLE_BUILD_FILE_NAMES.contains(file.getName());
    }

    private static boolean isGradleSettingsFile(VirtualFile file) {
        return GRADLE_SETTINGS_FILE_NAMES.contains(file.getName());
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        NotificationPanel(@NotNull String text2) {
            super((Color)null);
            this.setText(text2);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project project, @NotNull VirtualFile file, @Nullable GradleSyncNeededReason gradleSyncReason) {
                    return null;
                }
            }
            ,
            PROJECT_STRUCTURE{

                @Override
                @Nullable
                Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project project, @NotNull VirtualFile file, @Nullable GradleSyncNeededReason gradleSyncReason) {
                    if (ProjectStructureNotificationPanel.userAllowsShow()) {
                        if (!ProjectSyncStatusNotificationProvider.isDefaultGradleBuildFile(file) && !ProjectSyncStatusNotificationProvider.isGradleSettingsFile(file)) {
                            return null;
                        }
                        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
                        if (module == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) {
                                module = ModuleManager.getInstance((Project)project).getModules()[0];
                            } else {
                                return null;
                            }
                        }
                        Module finalModule = module;
                        return editor -> new ProjectStructureNotificationPanel(project, finalModule);
                    }
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project project, @NotNull VirtualFile file, @Nullable GradleSyncNeededReason gradleSyncReason) {
                    return editor -> new NotificationPanel("Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project project, @NotNull VirtualFile file, @Nullable GradleSyncNeededReason gradleSyncReason) {
                    String text2 = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return editor -> new SyncProblemNotificationPanel(project, text2);
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @Nullable
                Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project project, @NotNull VirtualFile file, @Nullable GradleSyncNeededReason gradleSyncReason) {
                    if (gradleSyncReason == null) {
                        return null;
                    }
                    String text2 = null;
                    switch (gradleSyncReason) {
                        case GRADLE_JVM_CONFIG_CHANGED: {
                            text2 = "Gradle JDK configuration has changed. A project sync may be necessary for the IDE to apply those changes.";
                            break;
                        }
                        case GRADLE_BUILD_FILES_CHANGED: {
                            text2 = "Gradle files have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                        }
                    }
                    String finalText = text2;
                    return editor -> new StaleGradleModelNotificationPanel(project, finalText);
                }
            };


            @Nullable
            abstract Function<? super FileEditor, NotificationPanel> getProvider(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable GradleSyncNeededReason var3);
        }
    }

    @VisibleForTesting
    static class ProjectStructureNotificationPanel
    extends NotificationPanel {
        private static final String TEXT = "You can use the Project Structure dialog to view and edit your project configuration";
        private static final long RESHOW_TIMEOUT_MS = TimeUnit.DAYS.toMillis(30L);

        ProjectStructureNotificationPanel(@NotNull Project project, @NotNull Module module) {
            super(TEXT);
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((String)"ShowProjectStructureSettings");
            Object label2 = "Open";
            if (!"".equals(shortcutText)) {
                label2 = (String)label2 + " (" + shortcutText + ")";
            }
            this.createActionLabel((String)label2, () -> {
                ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)project);
                if (projectSettingsService instanceof AndroidProjectSettingsService) {
                    projectSettingsService.openModuleSettings(module);
                }
            });
            this.createActionLabel("Hide notification", () -> {
                PropertiesComponent.getInstance().setValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", Long.toString(System.currentTimeMillis()));
                this.setVisible(false);
            });
        }

        @NotNull
        public Color getFallbackBackgroundColor() {
            return UIUtil.getPanelBackground();
        }

        static boolean userAllowsShow() {
            String lastHiddenValue;
            long lastHidden;
            long now = System.currentTimeMillis();
            return now - (lastHidden = Long.parseLong(lastHiddenValue = PropertiesComponent.getInstance().getValue("PROJECT_STRUCTURE_NOTIFICATION_LAST_HIDDEN_TIMESTAMP", "0"))) > RESHOW_TIMEOUT_MS;
        }
    }

    @VisibleForTesting
    static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull String text2) {
            super(text2);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_TRY_AGAIN), null));
            this.createActionLabel("Open 'Build' View", () -> {
                ToolWindow tw = BuildContentManager.getInstance((Project)project).getOrCreateToolWindow();
                if (tw != null && !tw.isActive()) {
                    tw.activate(null, false);
                }
            });
            this.createActionLabel("Show Log in " + RevealFileAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                RevealFileAction.openFile((File)logFile);
            });
        }
    }

    @VisibleForTesting
    static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull String text2) {
            super(text2);
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSync(project, new GradleSyncInvoker.Request(GradleSyncStats.Trigger.TRIGGER_USER_STALE_CHANGES), null));
            this.createActionLabel("Ignore these changes", () -> {
                GradleSyncStateHolder.getInstance(project).ignoreChangedFiles();
                this.setVisible(false);
            });
        }
    }
}

