/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.feature.flags.DeclarativeStudioSupport;
import com.intellij.openapi.vfs.VirtualFile;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectImportUtil {
    private static final String[] GRADLE_SUPPORTED_FILES = new String[]{"build.gradle", "build.gradle.kts", "settings.gradle", "settings.gradle.kts"};

    private ProjectImportUtil() {
    }

    public static VirtualFile findGradleTarget(@NotNull VirtualFile file) {
        if (DeclarativeStudioSupport.isEnabled()) {
            Object[] declarativeFiles = new String[]{"build.gradle.dcl", "settings.gradle.dcl"};
            return ProjectImportUtil.findMatch(file, (String[])ArrayUtils.addAll((Object[])GRADLE_SUPPORTED_FILES, (Object[])declarativeFiles));
        }
        return ProjectImportUtil.findMatch(file, GRADLE_SUPPORTED_FILES);
    }

    @Nullable
    private static VirtualFile findMatch(@NotNull VirtualFile location, String ... validNames) {
        if (location.isDirectory()) {
            for (VirtualFile child : location.getChildren()) {
                for (String name2 : validNames) {
                    if (!name2.equals(child.getName())) continue;
                    return child;
                }
            }
        } else {
            for (String name3 : validNames) {
                if (!name3.equals(location.getName())) continue;
                return location;
            }
        }
        return null;
    }
}

