/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.importing;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.config.GradleConfigManager;
import com.android.tools.idea.gradle.extensions.GradleDaemonJvmHelperExtensionsKt;
import com.android.tools.idea.gradle.project.ProjectMigrationsPersistentState;
import com.android.tools.idea.gradle.project.importing.GradleNewProjectConfiguration;
import com.android.tools.idea.gradle.project.sync.jdk.ProjectJdkUtils;
import com.android.tools.idea.gradle.toolchain.GradleDaemonJvmCriteriaInitializer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J3\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J%\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/project/importing/GradleJdkConfigurationInitializer;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "canInitializeDaemonJvmCriteria", "", "getCanInitializeDaemonJvmCriteria", "()Z", "setCanInitializeDaemonJvmCriteria", "(Z)V", "initialize", "", "project", "Lcom/intellij/openapi/project/Project;", "externalProjectPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "newProjectConfiguration", "Lcom/android/tools/idea/gradle/project/importing/GradleNewProjectConfiguration;", "setUpDaemonJvmCriteria", "Ljava/util/concurrent/CompletableFuture;", "setUpLocalJavaHomeAsGradleJvm", "setUpProjectJdkAsGradleJvm", "Companion", "intellij.android.projectSystem.gradle"})
public final class GradleJdkConfigurationInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @VisibleForTesting
    private boolean canInitializeDaemonJvmCriteria;

    private GradleJdkConfigurationInitializer() {
        Logger logger = Logger.getInstance(GradleJdkConfigurationInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.canInitializeDaemonJvmCriteria = !ApplicationManager.getApplication().isUnitTestMode();
    }

    public final boolean getCanInitializeDaemonJvmCriteria() {
        return this.canInitializeDaemonJvmCriteria;
    }

    public final void setCanInitializeDaemonJvmCriteria(boolean bl) {
        this.canInitializeDaemonJvmCriteria = bl;
    }

    public final void initialize(@NotNull Project project, @NotNull String externalProjectPath, @NotNull GradleProjectSettings projectSettings, @NotNull GradleNewProjectConfiguration newProjectConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        Intrinsics.checkNotNullParameter((Object)projectSettings, (String)"projectSettings");
        Intrinsics.checkNotNullParameter((Object)newProjectConfiguration, (String)"newProjectConfiguration");
        if (GradleDaemonJvmHelperExtensionsKt.isProjectUsingDaemonJvmCriteria(GradleDaemonJvmHelper.INSTANCE, project, projectSettings.getExternalProjectPath())) {
            return;
        }
        ((CompletableFuture)this.setUpDaemonJvmCriteria(project, externalProjectPath, projectSettings, newProjectConfiguration).handle((arg_0, arg_1) -> GradleJdkConfigurationInitializer.initialize$lambda$1((arg_0, arg_1) -> GradleJdkConfigurationInitializer.initialize$lambda$0(this, project, externalProjectPath, projectSettings, arg_0, arg_1), arg_0, arg_1))).get();
    }

    private final CompletableFuture<Boolean> setUpDaemonJvmCriteria(Project project, String externalProjectPath, GradleProjectSettings projectSettings, GradleNewProjectConfiguration newProjectConfiguration) {
        GradleVersion gradleVersion2 = GradleInstallationManager.Companion.guessGradleVersion(projectSettings);
        if (gradleVersion2 != null) {
            GradleVersion gradleVersion3 = gradleVersion2;
            boolean bl = false;
            if (GradleDaemonJvmHelperExtensionsKt.isDaemonJvmCriteriaRequiredForNewProjects(GradleDaemonJvmHelper.INSTANCE, gradleVersion3) && this.canInitializeDaemonJvmCriteria) {
                CompletionStage completionStage = new GradleDaemonJvmCriteriaInitializer(project, externalProjectPath, gradleVersion3).initialize(newProjectConfiguration.getUseDefaultDaemonJvmCriteria()).whenComplete((arg_0, arg_1) -> GradleJdkConfigurationInitializer.setUpDaemonJvmCriteria$lambda$4$lambda$3((arg_0, arg_1) -> GradleJdkConfigurationInitializer.setUpDaemonJvmCriteria$lambda$4$lambda$2(this, arg_0, arg_1), arg_0, arg_1));
                Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"whenComplete(...)");
                return completionStage;
            }
        }
        CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
        return completableFuture;
    }

    private final void setUpLocalJavaHomeAsGradleJvm(Project project, String externalProjectPath, GradleProjectSettings projectSettings) {
        projectSettings.setGradleJvm("#GRADLE_LOCAL_JAVA_HOME");
        GradleConfigManager.INSTANCE.initializeJavaHome(project, externalProjectPath);
        ProjectMigrationsPersistentState projectMigration = ProjectMigrationsPersistentState.Companion.getInstance(project);
        projectMigration.getMigratedGradleRootsToGradleLocalJavaHome().add(externalProjectPath);
    }

    private final void setUpProjectJdkAsGradleJvm(Project project, GradleProjectSettings projectSettings) {
        projectSettings.setGradleJvm("#USE_PROJECT_JDK");
        ProjectJdkUtils.INSTANCE.setUpEmbeddedJdkAsProjectJdk(project);
    }

    private static final Unit initialize$lambda$0(GradleJdkConfigurationInitializer this$0, Project $project, String $externalProjectPath, GradleProjectSettings $projectSettings, Boolean result2, Throwable exception) {
        if (Intrinsics.areEqual((Object)result2, (Object)false) || exception != null) {
            if (((Boolean)StudioFlags.GRADLE_USES_LOCAL_JAVA_HOME_FOR_NEW_CREATED_PROJECTS.get()).booleanValue() || ApplicationManager.getApplication().isUnitTestMode()) {
                this$0.setUpLocalJavaHomeAsGradleJvm($project, $externalProjectPath, $projectSettings);
            } else {
                this$0.setUpProjectJdkAsGradleJvm($project, $projectSettings);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit setUpDaemonJvmCriteria$lambda$4$lambda$2(GradleJdkConfigurationInitializer this$0, Boolean bl, Throwable error) {
        if (error != null) {
            this$0.logger.warn("Unable to initialize project Daemon JVM criteria", error);
        }
        return Unit.INSTANCE;
    }

    private static final void setUpDaemonJvmCriteria$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    @JvmStatic
    @NotNull
    public static final GradleJdkConfigurationInitializer getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/project/importing/GradleJdkConfigurationInitializer$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/gradle/project/importing/GradleJdkConfigurationInitializer;", "intellij.android.projectSystem.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleJdkConfigurationInitializer getInstance() {
            Object object = ApplicationManager.getApplication().getService(GradleJdkConfigurationInitializer.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GradleJdkConfigurationInitializer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

