/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.library;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryPropertiesDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Library myLibrary;
    private JPanel myMainPanel;
    private JPanel myTreePanel;
    private JBLabel myIconLabel;
    private JBLabel myNameLabel;
    private LibraryRootsComponent myLibraryEditorComponent;
    private SourcesAndDocsOnlyEditor myEditor;

    public LibraryPropertiesDialog(@NotNull Project project, @NotNull Library library) {
        super(project);
        this.setupUI();
        this.myProject = project;
        this.myLibrary = library;
        this.init();
        this.setTitle("Library Properties");
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myIconLabel.setIcon(AllIcons.Nodes.PpLib);
        this.myNameLabel.setText(this.myLibrary.getName());
        this.myEditor = new SourcesAndDocsOnlyEditor(this.myLibrary);
        this.myLibraryEditorComponent = new LibraryRootsComponent(this, this.myProject, (LibraryEditor)this.myEditor){

            public void updatePropertiesLabel() {
                MultiLineLabel propertiesLabel;
                JComponent c = this.getComponent();
                if (c != null && (propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class)) != null) {
                    propertiesLabel.setText("Add or remove source/Javadoc attachments");
                }
            }
        };
        this.myLibraryEditorComponent.updatePropertiesLabel();
        JComponent c = this.myLibraryEditorComponent.getComponent();
        MultiLineLabel propertiesLabel = (MultiLineLabel)UIUtil.findComponentOfType((JComponent)c, MultiLineLabel.class);
        if (propertiesLabel != null) {
            propertiesLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 1));
        }
        this.myTreePanel.add((Component)c, "Center");
        this.myTreePanel.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)1, (int)1, (int)1));
        return this.myMainPanel;
    }

    protected void dispose() {
        if (this.myLibraryEditorComponent != null) {
            Disposer.dispose((Disposable)this.myLibraryEditorComponent);
        }
        super.dispose();
    }

    public void applyChanges() {
        if (this.myEditor != null) {
            LibraryPropertiesDialog.executeProjectChanges(this.myProject, () -> ((SourcesAndDocsOnlyEditor)this.myEditor).commit());
        }
    }

    private static void executeProjectChanges(@NotNull Project project, @NotNull Runnable changes) {
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            if (!project.isDisposed()) {
                changes.run();
            }
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            if (!project.isDisposed()) {
                ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(changes);
            }
        }));
    }

    @VisibleForTesting
    LibraryRootsComponent getLibraryEditorComponent() {
        return this.myLibraryEditorComponent;
    }

    private void setupUI() {
        this.myMainPanel = new JPanel();
        this.myMainPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.myTreePanel = new JPanel();
        this.myTreePanel.setLayout(new BorderLayout(0, 0));
        this.myMainPanel.add((Component)this.myTreePanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, new Dimension(600, 400), null, 0, false));
        this.myIconLabel = new JBLabel();
        this.myMainPanel.add((Component)this.myIconLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 1, null, null, null, 0, false));
        this.myNameLabel = new JBLabel();
        this.myMainPanel.add((Component)this.myNameLabel, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 4, null, null, null, 0, false));
    }

    private static class SourcesAndDocsOnlyEditor
    extends ExistingLibraryEditor {
        SourcesAndDocsOnlyEditor(@NotNull Library library) {
            super(library, null);
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                return ArrayUtil.EMPTY_STRING_ARRAY;
            }
            return super.getUrls(rootType);
        }

        public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(file, rootType);
            }
        }

        public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.addRoot(url, rootType);
            }
        }

        public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
            if (!SourcesAndDocsOnlyEditor.isIgnored(rootType)) {
                super.removeRoot(url, rootType);
            }
        }

        private static boolean isIgnored(@NotNull OrderRootType rootType) {
            return rootType == OrderRootType.CLASSES;
        }
    }
}

