/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/InstallPlatformQuickFix;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "androidVersions", "", "Lcom/android/sdklib/AndroidVersion;", "<init>", "(Ljava/util/List;)V", "id", "", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.projectSystem.gradle"})
public final class InstallPlatformQuickFix
implements BuildIssueQuickFix {
    @NotNull
    private final List<AndroidVersion> androidVersions;
    @NotNull
    private final String id;

    public InstallPlatformQuickFix(@NotNull List<AndroidVersion> androidVersions) {
        Intrinsics.checkNotNullParameter(androidVersions, (String)"androidVersions");
        this.androidVersions = androidVersions;
        this.id = "install.android.platform";
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        CompletableFuture future2 = new CompletableFuture();
        List platforms = new ArrayList();
        ActionsKt.invokeLater$default(null, () -> InstallPlatformQuickFix.runQuickFix$lambda$0(this, platforms, project, future2), (int)1, null);
        return future2;
    }

    private static final Unit runQuickFix$lambda$0(InstallPlatformQuickFix this$0, List $platforms, Project $project, CompletableFuture $future) {
        for (AndroidVersion version2 : this$0.androidVersions) {
            String string = DetailsTypes.getPlatformPath((AndroidVersion)version2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlatformPath(...)");
            $platforms.add(string);
        }
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths($project, $platforms);
        if (dialog2 != null && dialog2.showAndGet()) {
            ProjectSystemUtil.getSyncManager($project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_PLATFORM_INSTALLED));
        }
        $future.complete(null);
        return Unit.INSTANCE;
    }
}

