/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.repository.Revision;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"VERSION_PATTERN", "", "PREFERRED_VERSION_PATTERNS", "", "Lkotlin/text/Regex;", "tryExtractPreferredNdkDownloadVersion", "Lcom/android/repository/Revision;", "text", "intellij.android.projectSystem.gradle"})
public final class MissingNdkIssueCheckerKt {
    @NotNull
    private static final String VERSION_PATTERN = "(?<version>([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?([\\s-]*)?(?:(rc|alpha|beta|\\.)([0-9]+))?)";
    @NotNull
    private static final List<Regex> PREFERRED_VERSION_PATTERNS;

    @Nullable
    public static final Revision tryExtractPreferredNdkDownloadVersion(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        for (Regex pattern : PREFERRED_VERSION_PATTERNS) {
            MatchResult matchResult = pattern.matchEntire((CharSequence)text2);
            if (matchResult == null) continue;
            MatchResult result2 = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)result2.getGroups(), (String)"version");
            Intrinsics.checkNotNull((Object)matchGroup);
            String version2 = matchGroup.getValue();
            return Revision.parseRevision((String)version2);
        }
        return null;
    }

    static {
        Object[] objectArray = new Regex[]{new Regex("NDK not configured. Download it with SDK manager. Preferred NDK version is '(?<version>([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?([\\s-]*)?(?:(rc|alpha|beta|\\.)([0-9]+))?)'.*"), new Regex("No version of NDK matched the requested version (?<version>([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?([\\s-]*)?(?:(rc|alpha|beta|\\.)([0-9]+))?).*")};
        PREFERRED_VERSION_PATTERNS = CollectionsKt.listOf((Object[])objectArray);
    }
}

