/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.annotations.concurrency.Slow;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.errors.FixBuildToolsVersionQuickFix;
import com.android.tools.idea.gradle.project.sync.errors.SdkBuildToolsTooLowIssueCheckerKt;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueComposer;
import com.android.tools.idea.gradle.project.sync.idea.issues.BuildIssueUtilKt;
import com.android.tools.idea.gradle.project.sync.issues.SyncFailureUsageReporter;
import com.android.tools.idea.gradle.project.sync.quickFixes.InstallBuildToolsQuickFix;
import com.android.tools.idea.gradle.project.sync.quickFixes.OpenFileAtLocationQuickFix;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.gradle.GradleHolderProjectPath;
import com.android.tools.idea.projectsystem.gradle.GradleProjectPathKt;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.sdk.AndroidSdkData;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleIssueChecker;
import org.jetbrains.plugins.gradle.issue.GradleIssueData;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0003JD\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001a0\u0019H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/project/sync/errors/SdkBuildToolsTooLowIssueChecker;", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueChecker;", "<init>", "()V", "SDK_BUILD_TOOLS_TOO_LOW_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "check", "Lcom/intellij/build/issue/BuildIssue;", "issueData", "Lorg/jetbrains/plugins/gradle/issue/GradleIssueData;", "getBuildIssueDescriptionAndQuickFixes", "Lcom/android/tools/idea/gradle/project/sync/idea/issues/BuildIssueComposer;", "message", "", "projectPath", "consumeBuildOutputFailureMessage", "", "failureCause", "stacktrace", "location", "Lcom/intellij/build/FilePosition;", "parentEventId", "", "messageConsumer", "Ljava/util/function/Consumer;", "Lcom/intellij/build/events/BuildEvent;", "intellij.android.projectSystem.gradle"})
public final class SdkBuildToolsTooLowIssueChecker
implements GradleIssueChecker {
    private final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @Slow
    @Nullable
    public BuildIssue check(@NotNull GradleIssueData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        String string = ((Throwable)GradleExecutionErrorHandler.getRootCauseAndLocation((Throwable)issueData.getError()).first).getMessage();
        if (string == null) {
            return null;
        }
        String message = string;
        if (((CharSequence)message).length() == 0) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = this.getBuildIssueDescriptionAndQuickFixes(message, issueData.getProjectPath());
        if (buildIssueComposer == null) {
            return null;
        }
        BuildIssueComposer composer = buildIssueComposer;
        SyncFailureUsageReporter.Companion.getInstance().collectFailure(issueData.getProjectPath(), AndroidStudioEvent.GradleSyncFailure.SDK_BUILD_TOOLS_TOO_LOW);
        return composer.composeBuildIssue();
    }

    @Slow
    private final BuildIssueComposer getBuildIssueDescriptionAndQuickFixes(String message, String projectPath) {
        AndroidSdkHandler sdkHandler;
        Matcher matcher = this.SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(message);
        if (!matcher.matches()) {
            return null;
        }
        BuildIssueComposer buildIssueComposer = new BuildIssueComposer(message, null, 2, null);
        String gradlePath = matcher.group(2);
        String minVersion = matcher.group(3);
        Project project = BuildIssueUtilKt.fetchIdeaProjectForGradleProject(projectPath);
        if (project == null) {
            return buildIssueComposer;
        }
        Project ideaProject = project;
        String string = FileUtil.toSystemIndependentName((String)projectPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        Intrinsics.checkNotNull((Object)gradlePath);
        List modules = CollectionsKt.listOfNotNull((Object)GradleProjectPathKt.resolveIn(new GradleHolderProjectPath(string, gradlePath), ideaProject));
        List buildFiles = CollectionsKt.listOfNotNull(modules.isEmpty() ? null : GradleProjectSystemUtil.getGradleBuildFile((Module)modules.get(0)));
        AndroidSdkData androidSdkData = AndroidSdks.getInstance().tryToChooseAndroidSdk();
        Object object = sdkHandler = androidSdkData != null ? androidSdkData.getSdkHandler() : null;
        if (sdkHandler != null) {
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(SdkBuildToolsTooLowIssueChecker.class);
            RepositoryPackages packages = sdkHandler.getRepoManagerAndLoadSynchronously((ProgressIndicator)progress2).getPackages();
            LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minVersion)));
            if (buildTool == null) {
                String linkMessage = "Install Build Tools " + minVersion + " " + (!((Collection)buildFiles).isEmpty() ? ", update version in build file and sync project" : " and sync project");
                Intrinsics.checkNotNull((Object)minVersion);
                buildIssueComposer.addQuickFix(linkMessage, new InstallBuildToolsQuickFix(minVersion, buildFiles, SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(ideaProject)));
            } else if (!((Collection)buildFiles).isEmpty()) {
                boolean removeBuildTools = SdkBuildToolsTooLowIssueCheckerKt.doesAndroidGradlePluginPackageBuildTools(ideaProject);
                String string2 = (removeBuildTools ? "Remove" : "Update") + " Build Tools version and sync project";
                Intrinsics.checkNotNull((Object)minVersion);
                buildIssueComposer.addQuickFix(string2, new FixBuildToolsVersionQuickFix(minVersion, buildFiles, removeBuildTools));
            }
        }
        if (!((Collection)buildFiles).isEmpty()) {
            buildIssueComposer.addQuickFix("Open file.", new OpenFileAtLocationQuickFix(new FilePosition(new File(((VirtualFile)buildFiles.get(0)).getPath()), -1, -1)));
        }
        return buildIssueComposer;
    }

    public boolean consumeBuildOutputFailureMessage(@NotNull String message, @NotNull String failureCause, @Nullable String stacktrace, @Nullable FilePosition location, @NotNull Object parentEventId, @NotNull Consumer<? super BuildEvent> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)failureCause, (String)"failureCause");
        Intrinsics.checkNotNullParameter((Object)parentEventId, (String)"parentEventId");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        return this.SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(failureCause).matches();
    }
}

