/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.repository.Revision;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.project.sync.hyperlink.HyperlinkUtil;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.processor.FixBuildToolsProcessor;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InstallBuildToolsHyperlink
extends SyncIssueNotificationHyperlink {
    @NotNull
    private final String myVersion;
    @NotNull
    private final List<VirtualFile> myBuildFiles;
    private final boolean myRemoveBuildTools;

    public InstallBuildToolsHyperlink(@NotNull String version2) {
        this(version2, (List<VirtualFile>)ImmutableList.of(), false);
    }

    public InstallBuildToolsHyperlink(@NotNull String version2, @NotNull List<VirtualFile> buildFiles, boolean removeBuildTools) {
        super("install.build.tools", InstallBuildToolsHyperlink.getText(version2, !buildFiles.isEmpty(), removeBuildTools), AndroidStudioEvent.GradleSyncQuickFix.INSTALL_BUILD_TOOLS_HYPERLINK);
        this.myBuildFiles = buildFiles;
        this.myVersion = version2;
        this.myRemoveBuildTools = removeBuildTools;
    }

    @NotNull
    private static String getText(@NotNull String version2, boolean hasBuildFiles, boolean myRemoveBuildTools) {
        StringBuilder msg = new StringBuilder(String.format("Install Build Tools %1$s", version2));
        if (hasBuildFiles) {
            if (myRemoveBuildTools) {
                msg.append(", remove version from build file to use the default one provided by AGP and sync project");
            } else {
                msg.append(", update version in build file to use the default one provided by AGP and sync project");
            }
        } else {
            msg.append(" and sync project");
        }
        return msg.toString();
    }

    @Override
    protected void execute(@NotNull Project project) {
        ArrayList<String> requested = new ArrayList<String>();
        Revision minBuildToolsRev = Revision.parseRevision((String)this.myVersion);
        requested.add(DetailsTypes.getBuildToolsPath((Revision)minBuildToolsRev));
        ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(project, requested);
        if (dialog2 != null && dialog2.showAndGet()) {
            if (!this.myBuildFiles.isEmpty()) {
                FixBuildToolsProcessor processor = new FixBuildToolsProcessor(project, this.myBuildFiles, this.myVersion, true, this.myRemoveBuildTools);
                processor.setPreviewUsages(true);
                processor.run();
            } else {
                HyperlinkUtil.requestProjectSync(project, GradleSyncStats.Trigger.TRIGGER_QF_BUILD_TOOLS_INSTALLED);
            }
        }
    }
}

