/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.model.IdeSyncIssue;
import com.android.tools.idea.gradle.project.sync.hyperlink.AddGoogleMavenRepositoryHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.DisableOfflineModeHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowDependencyInProjectStructureHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.ShowSyncIssuesDetailsHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssueNotificationHyperlink;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class UnresolvedDependenciesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    private static final String UNRESOLVED_DEPENDENCIES_GROUP = "Unresolved dependencies";
    private boolean myAssumeProjectNotInitialized = false;

    @Override
    public int getSupportedIssueType() {
        return 2;
    }

    @Override
    @NotNull
    protected List<SyncIssueNotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        assert (!syncIssues.isEmpty() && !affectedModules.isEmpty());
        IdeSyncIssue issue2 = syncIssues.get(0);
        String dependency = issue2.getData();
        ArrayList<SyncIssueNotificationHyperlink> quickFixes = new ArrayList<SyncIssueNotificationHyperlink>();
        if (dependency == null) {
            if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(0, new DisableOfflineModeHyperlink());
            }
        } else {
            List buildFiles = ContainerUtil.map(affectedModules, m -> (VirtualFile)buildFileMap.get(m));
            Module module = affectedModules.get(0);
            if (dependency.startsWith("com.android.support") || dependency.startsWith("androidx.") || dependency.startsWith("com.google.android")) {
                this.addGoogleMavenRepositoryHyperlink(project, buildFiles, quickFixes);
            } else if (GradleProjects.isOfflineBuildModeEnabled(project)) {
                quickFixes.add(new DisableOfflineModeHyperlink());
            }
            if (IdeInfo.getInstance().isAndroidStudio()) {
                quickFixes.add(new ShowDependencyInProjectStructureHyperlink(module, dependency));
            }
        }
        ArrayList<String> extraInfo = new ArrayList<String>();
        try {
            List multiLineMessage = issue2.getMultiLineMessage();
            if (multiLineMessage != null && !issue2.getMultiLineMessage().isEmpty()) {
                extraInfo.addAll(multiLineMessage);
            }
        }
        catch (UnsupportedOperationException multiLineMessage) {
            // empty catch block
        }
        if (!extraInfo.isEmpty()) {
            try {
                String encodedMessage = URLEncoder.encode(issue2.getMessage(), "UTF-8").replace("+", " ");
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(encodedMessage, extraInfo));
            }
            catch (UnsupportedEncodingException e) {
                quickFixes.add(new ShowSyncIssuesDetailsHyperlink(issue2.getMessage(), extraInfo));
            }
        }
        return quickFixes;
    }

    @Override
    @NotNull
    protected SyncMessage setupSyncMessage(@NotNull Project project, @NotNull List<IdeSyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap, @NotNull MessageType type) {
        SyncMessage syncMessage = super.setupSyncMessage(project, syncIssues, affectedModules, buildFileMap, type);
        syncMessage = new SyncMessage(UNRESOLVED_DEPENDENCIES_GROUP, syncMessage.getType(), syncMessage.getNavigatable(), syncMessage.getText());
        String dependency = syncIssues.get(0).getData();
        if (dependency == null) {
            return syncMessage;
        }
        String message = "Failed to resolve: " + dependency;
        syncMessage = new SyncMessage(syncMessage.getGroup(), syncMessage.getType(), syncMessage.getNavigatable(), message);
        return syncMessage;
    }

    private void addGoogleMavenRepositoryHyperlink(@NotNull Project project, @NotNull List<VirtualFile> buildFiles, @NotNull List<SyncIssueNotificationHyperlink> fixes) {
        if (!project.isInitialized() || this.myAssumeProjectNotInitialized) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink(project));
            return;
        }
        ProjectBuildModel projectBuildModel = ProjectBuildModel.getOrLog(project);
        if (projectBuildModel == null) {
            return;
        }
        GradleSettingsModel settingsModel = projectBuildModel.getProjectSettingsModel();
        if (settingsModel != null && settingsModel.dependencyResolutionManagement().repositories().hasGoogleMavenRepository()) {
            return;
        }
        ArrayList<VirtualFile> filesToFix = new ArrayList<VirtualFile>();
        for (VirtualFile file : buildFiles) {
            GradleBuildModel moduleModel;
            if (file == null || !file.isValid() || (moduleModel = projectBuildModel.getModuleBuildModel(file)).repositories().hasGoogleMavenRepository()) continue;
            filesToFix.add(file);
        }
        if (filesToFix.isEmpty()) {
            return;
        }
        GradleBuildModel buildModel = projectBuildModel.getProjectBuildModel();
        if (buildModel != null && !buildModel.repositories().hasGoogleMavenRepository()) {
            fixes.add(new AddGoogleMavenRepositoryHyperlink((List<VirtualFile>)ImmutableList.of((Object)buildModel.getVirtualFile())));
            return;
        }
        fixes.add(new AddGoogleMavenRepositoryHyperlink(filesToFix));
    }

    @VisibleForTesting
    public void assumeProjectNotInitialized(boolean assumeNotInitialized) {
        this.myAssumeProjectNotInitialized = assumeNotInitialized;
    }
}

