/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues.processor;

import com.android.tools.idea.gradle.dsl.android.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.android.model.android.AndroidModelUtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.CompileSdkPropertyModel;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0017\u00a2\u0006\u0002\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0017\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00152\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0007\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/gradle/project/sync/issues/processor/UpdateCompileSdkProcessor;", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "buildFilesWithNewMinCompileSdk", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createUsageViewDescriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)Lcom/intellij/usageView/UsageViewDescriptor;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "performRefactoring", "", "([Lcom/intellij/usageView/UsageInfo;)V", "updateProjectBuildModel", "getCommandName", "", "intellij.android.projectSystem.gradle"})
public final class UpdateCompileSdkProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<VirtualFile, Integer> buildFilesWithNewMinCompileSdk;

    public UpdateCompileSdkProcessor(@NotNull Project project, @NotNull Map<VirtualFile, Integer> buildFilesWithNewMinCompileSdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildFilesWithNewMinCompileSdk, (String)"buildFilesWithNewMinCompileSdk");
        super(project);
        this.project = project;
        this.buildFilesWithNewMinCompileSdk = buildFilesWithNewMinCompileSdk;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        return new UsageViewDescriptor(){

            public PsiElement[] getElements() {
                Intrinsics.checkNotNullExpressionValue((Object)PsiElement.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return "Update Compile SDK Versions";
            }

            public String getCodeReferencesText(int usagesCount, int filesCount) {
                return "Compile Sdk versions to update (" + usagesCount + " usage" + (usagesCount == 1 ? "" : "s") + " in " + filesCount + " file" + (filesCount == 1 ? "" : "s") + ")";
            }
        };
    }

    @VisibleForTesting
    @NotNull
    public UsageInfo[] findUsages() {
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        List usages = new ArrayList();
        for (Map.Entry<VirtualFile, Integer> entry : this.buildFilesWithNewMinCompileSdk.entrySet()) {
            PsiElement element;
            CompileSdkPropertyModel existingCompileSdkVersion;
            VirtualFile file = entry.getKey();
            int newMinCompileSdk = ((Number)entry.getValue()).intValue();
            if (!file.isValid() || !file.isWritable()) continue;
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(file);
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"getModuleBuildModel(...)");
            AndroidModel android = AndroidModelUtilsKt.android(gradleBuildModel);
            Intrinsics.checkNotNullExpressionValue((Object)android.compileSdkVersion(), (String)"compileSdkVersion(...)");
            if (Intrinsics.areEqual((Object)String.valueOf(newMinCompileSdk), (Object)existingCompileSdkVersion.toString()) || (element = existingCompileSdkVersion.getFullExpressionPsiElement()) == null) continue;
            usages.add(new UsageInfo(element));
        }
        Collection collection2 = usages;
        Intrinsics.checkNotNullExpressionValue((Object)UsageInfo.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (UsageInfo[])UtilKt.toArray((Collection)collection2, (Object[])UsageInfo.EMPTY_ARRAY);
    }

    @VisibleForTesting
    public void performRefactoring(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        this.updateProjectBuildModel(usages);
        ProjectSystemUtil.getSyncManager(this.project).requestSyncProject(ProjectSystemSyncUtil.toReason(GradleSyncStats.Trigger.TRIGGER_QF_MIN_COMPILE_SDK_UPDATED));
    }

    @VisibleForTesting
    public final void updateProjectBuildModel(@NotNull UsageInfo[] usages) {
        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)projectBuildModel, (String)"get(...)");
        ProjectBuildModel projectBuildModel2 = projectBuildModel;
        List elements = Arrays.stream(usages).map(arg_0 -> UpdateCompileSdkProcessor.updateProjectBuildModel$lambda$1(UpdateCompileSdkProcessor::updateProjectBuildModel$lambda$0, arg_0)).collect(Collectors.toList());
        for (Map.Entry<VirtualFile, Integer> entry : this.buildFilesWithNewMinCompileSdk.entrySet()) {
            CompileSdkPropertyModel compileSdkVersion2;
            VirtualFile file = entry.getKey();
            int newMinCompileSdk = ((Number)entry.getValue()).intValue();
            GradleBuildModel gradleBuildModel = projectBuildModel2.getModuleBuildModel(file);
            Intrinsics.checkNotNullExpressionValue((Object)gradleBuildModel, (String)"getModuleBuildModel(...)");
            AndroidModel android = AndroidModelUtilsKt.android(gradleBuildModel);
            Intrinsics.checkNotNullExpressionValue((Object)android.compileSdkVersion(), (String)"compileSdkVersion(...)");
            PsiElement element = compileSdkVersion2.getFullExpressionPsiElement();
            if (element == null || !elements.contains(element)) continue;
            compileSdkVersion2.setValue(newMinCompileSdk);
        }
        projectBuildModel2.applyChanges();
    }

    @NotNull
    protected String getCommandName() {
        return "Update Compile Sdk Version";
    }

    private static final PsiElement updateProjectBuildModel$lambda$0(UsageInfo usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        return usage.getElement();
    }

    private static final PsiElement updateProjectBuildModel$lambda$1(Function1 $tmp0, Object p0) {
        return (PsiElement)$tmp0.invoke(p0);
    }
}

