/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.jdk.exceptions;

import com.android.tools.idea.gradle.project.sync.jdk.exceptions.base.GradleJdkException;
import com.android.tools.idea.gradle.project.sync.jdk.exceptions.cause.InvalidGradleJdkCause;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.tools.projectWizard.core.UtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/InvalidTableEntryJdkException;", "Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/base/GradleJdkException;", "project", "Lcom/intellij/openapi/project/Project;", "gradleRootPath", "", "Lorg/jetbrains/annotations/SystemIndependent;", "jdkName", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "cause", "Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/cause/InvalidGradleJdkCause;", "getCause", "()Lcom/android/tools/idea/gradle/project/sync/jdk/exceptions/cause/InvalidGradleJdkCause;", "intellij.android.projectSystem.gradle"})
public final class InvalidTableEntryJdkException
extends GradleJdkException {
    @NotNull
    private final String jdkName;

    public InvalidTableEntryJdkException(@NotNull Project project, @NotNull String gradleRootPath, @NotNull String jdkName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gradleRootPath, (String)"gradleRootPath");
        Intrinsics.checkNotNullParameter((Object)jdkName, (String)"jdkName");
        super(project, gradleRootPath);
        this.jdkName = jdkName;
    }

    @Override
    @NotNull
    protected InvalidGradleJdkCause getCause() {
        String string = ExternalSystemJdkUtil.getJavaSdkType().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String javaSdkTypeName = string;
        Sdk sdk = ProjectJdkTable.getInstance().findJdk(this.jdkName, javaSdkTypeName);
        if (sdk == null) {
            return new InvalidGradleJdkCause.UndefinedGradleJvmTableEntry(this.jdkName);
        }
        Sdk existingJdk = sdk;
        Object object = existingJdk.getHomePath();
        if (object == null || (object = UtilsKt.asPath((String)object)) == null) {
            return new InvalidGradleJdkCause.UndefinedGradleJvmTableEntryJavaHome(this.jdkName);
        }
        Object jdkPath = object;
        return new InvalidGradleJdkCause.InvalidGradleJvmTableEntryJavaHome((Path)jdkPath, this.jdkName);
    }
}

