/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.sync.setup.post.TimeBasedReminder;
import com.android.tools.idea.memorysettings.MemorySettingsRecommendation;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.google.wireless.android.sdk.stats.MemorySettingsEvent;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.system.CpuArch;
import java.util.Locale;
import org.jetbrains.android.util.AndroidBundle;

public class MemorySettingsPostSyncChecker {
    public static final double MEMORY_THRESHOLD_PERCENTAGE = 0.9;
    private static final Logger LOG = Logger.getInstance(MemorySettingsPostSyncChecker.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Memory Settings Notification");

    public static void checkSettings(Project project, TimeBasedReminder reminder) {
        int recommended;
        LOG.info(String.format(Locale.US, "64bits? : %b, current: %d, available RAM: %d", !CpuArch.is32Bit(), MemorySettingsUtil.getCurrentXmx(), MemorySettingsUtil.getMachineMem()));
        if (!MemorySettingsUtil.memorySettingsEnabled() || !reminder.shouldAsk() || MemorySettingsPostSyncChecker.hasNotification(project)) {
            LOG.info("Skipped checking memory settings");
            return;
        }
        int currentXmx = MemorySettingsUtil.getCurrentXmx();
        if ((double)currentXmx < (double)(recommended = MemorySettingsRecommendation.getRecommended(project, currentXmx)) * 0.9) {
            MemorySettingsPostSyncChecker.showNotification(project, currentXmx, recommended, reminder);
        }
    }

    private static boolean hasNotification(Project project) {
        return ((MemorySettingsNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MemorySettingsNotification.class, project)).length > 0;
    }

    private static void showNotification(Project project, int currentXmx, int recommended, TimeBasedReminder reminder) {
        MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.SHOW_RECOMMENDATION, currentXmx, recommended);
        reminder.updateLastTimestamp();
        MemorySettingsNotification notification = new MemorySettingsNotification(AndroidBundle.message("memory.settings.postsync.message", String.valueOf(currentXmx), String.valueOf(recommended)));
        notification.setTitle(AndroidBundle.message("memory.settings.postsync.title", ApplicationNamesInfo.getInstance().getFullProductName()));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)AndroidBundle.message("memory.settings.postsync.save", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.SAVE_AND_RESTART, currentXmx, recommended);
            MemorySettingsUtil.saveXmx(recommended);
            ApplicationManagerEx.getApplicationEx().restart(true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)AndroidBundle.message("memory.settings.postsync.configure", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.CONFIGURE, currentXmx, recommended);
            ShowSettingsUtilImpl.showSettingsDialog((Project)project, (String)"memory.settings", (String)"");
            reminder.setDoNotAskForProject(true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)AndroidBundle.message("memory.settings.postsync.do.not.ask.for.project", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.DO_NOT_ASK, currentXmx, recommended);
            reminder.setDoNotAskForProject(true);
        }));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)AndroidBundle.message("memory.settings.postsync.do.not.show.again", new Object[0]), () -> {
            MemorySettingsPostSyncChecker.log(MemorySettingsEvent.EventKind.DO_NOT_ASK, currentXmx, recommended);
            reminder.setDoNotAskForApplication(true);
        }));
        notification.notify(project);
    }

    private static void log(MemorySettingsEvent.EventKind kind, int currentXmx, int recommended) {
        MemorySettingsUtil.log(kind, currentXmx, -1, -1, recommended, -1, -1, -1, -1, -1);
    }

    static class MemorySettingsNotification
    extends Notification {
        public MemorySettingsNotification(String content2) {
            super(NOTIFICATION_GROUP.getDisplayId(), "Memory Settings", content2, NotificationType.INFORMATION);
        }
    }
}

