/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.BasePerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.PsAllModulesFakeModule;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.util.GradleProjectSystemUtil;
import com.android.tools.idea.gradle.util.ui.LabeledComboBoxAction;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import icons.StudioIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ModulesComboBoxAction
extends LabeledComboBoxAction {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final BasePerspectiveConfigurable myBasePerspective;

    public ModulesComboBoxAction(@NotNull PsContext context, @NotNull BasePerspectiveConfigurable basePerspective) {
        super("Module: ");
        this.myContext = context;
        this.myBasePerspective = basePerspective;
    }

    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        PsModule selectedModule = this.myBasePerspective.getSelectedModule();
        presentation.setIcon(selectedModule != null ? selectedModule.getIcon() : StudioIcons.Shell.Filetree.ANDROID_MODULE);
        presentation.setText(selectedModule != null ? selectedModule.getName() : null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (PsModule module2 : this.myBasePerspective.getExtraModules()) {
            group2.add((AnAction)new ModuleAction(module2));
        }
        group2.addSeparator();
        this.myContext.getProject().getModules().stream().filter(PsModule::isDeclared).forEach(module -> group2.add((AnAction)new ModuleAction((PsModule)module)));
        return group2;
    }

    @NotNull
    private static String fullPath(@NotNull PsModule module) {
        String gradlePath = module.getGradlePath();
        if (module instanceof PsAllModulesFakeModule) {
            return module.getName();
        }
        String parentPath = GradleProjectSystemUtil.getParentModulePath(gradlePath);
        return new HtmlBuilder().openHtmlBody().add(parentPath).add(":").addBold(module.getName()).closeHtmlBody().getHtml();
    }

    private class ModuleAction
    extends DumbAwareAction {
        @NotNull
        private final String myModuleGradlePath;

        ModuleAction(PsModule module) {
            super(ModulesComboBoxAction.fullPath(module), "", module.getIcon());
            this.myModuleGradlePath = module.getGradlePath();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ModulesComboBoxAction.this.myBasePerspective.selectModule(this.myModuleGradlePath);
        }
    }
}

