/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.BitUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public final class UiUtil {
    private UiUtil() {
    }

    public static void revalidateAndRepaint(@NotNull JComponent c) {
        c.doLayout();
        c.revalidate();
        c.repaint();
    }

    @NotNull
    public static JScrollPane setUp(@NotNull JTree tree, @NotNull String name2) {
        tree.setExpandsSelectedPaths(true);
        tree.setRootVisible(false);
        tree.setName(name2);
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        selectionModel.setSelectionMode(4);
        new TreeSpeedSearch(tree);
        JScrollPane scrollPane2 = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane2.setBorder((Border)JBUI.Borders.empty());
        return scrollPane2;
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull KeyEvent e) {
        return e.getKeyCode() == (ClientSystemInfo.isMac() ? 157 : 17);
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull MouseEvent e) {
        int modifiers = e.getModifiers();
        return BitUtil.isSet((int)modifiers, (int)(ClientSystemInfo.isMac() ? 4 : 2));
    }
}

