/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.projectsystem.gradle.IdeGooglePlaySdkIndex;
import com.intellij.openapi.Disposable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u000e2\u000e\b\u0001\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/android/tools/idea/gradle/structure/model/PsProject;", "<init>", "(Lcom/intellij/openapi/Disposable;Lcom/android/tools/idea/gradle/structure/model/PsProject;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon$SdkIndexIssuesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "queueCheck", "", "add", "listener", "Lkotlin/Function0;", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "RefreshSdkIndexIssues", "SdkIndexAvailable", "SdkIndexIssuesListener", "intellij.android.projectSystem.gradle.psd"})
public final class PsSdkIndexCheckerDaemon
extends PsDaemon {
    @NotNull
    private final PsProject project;
    @NotNull
    private final EventDispatcher<SdkIndexIssuesListener> eventDispatcher;
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;

    public PsSdkIndexCheckerDaemon(@NotNull Disposable parentDisposable, @NotNull PsProject project) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(parentDisposable);
        this.project = project;
        EventDispatcher eventDispatcher = EventDispatcher.create(SdkIndexIssuesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.mainQueue = this.createQueue("Project Structure Daemon SDK Index Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure SDK Index Results Updater", MergingUpdateQueue.ANY_COMPONENT);
    }

    public final void queueCheck() {
        this.getMainQueue().queue((Update)new RefreshSdkIndexIssues());
    }

    public final void add(@UiThread @NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)new SdkIndexIssuesListener(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            @UiThread
            public void availableIssues() {
                this.$listener.invoke();
            }
        }, parentDisposable);
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon$RefreshSdkIndexIssues;", "Lcom/intellij/util/ui/update/Update;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class RefreshSdkIndexIssues
    extends Update {
        public RefreshSdkIndexIssues() {
            super((Object)PsSdkIndexCheckerDaemon.this.project, false, 0, 6, null);
        }

        public void run() {
            IdeGooglePlaySdkIndex.INSTANCE.initializeAndSetFlags();
            PsSdkIndexCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new SdkIndexAvailable());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon$SdkIndexAvailable;", "Lcom/intellij/util/ui/update/Update;", "<init>", "(Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon;)V", "run", "", "intellij.android.projectSystem.gradle.psd"})
    private final class SdkIndexAvailable
    extends Update {
        public SdkIndexAvailable() {
            super((Object)PsSdkIndexCheckerDaemon.this.project, false, 0, 6, null);
        }

        @UiThread
        public void run() {
            ((SdkIndexIssuesListener)PsSdkIndexCheckerDaemon.this.eventDispatcher.getMulticaster()).availableIssues();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsSdkIndexCheckerDaemon$SdkIndexIssuesListener;", "Ljava/util/EventListener;", "availableIssues", "", "intellij.android.projectSystem.gradle.psd"})
    private static interface SdkIndexIssuesListener
    extends EventListener {
        @UiThread
        public void availableIssues();
    }
}

