/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.android.tools.idea.gradle.structure.model.meta.ModelProperty;
import com.intellij.openapi.application.ApplicationManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/analysis/PsMissingBuildTypeFallbackQuickFix;", "Lcom/android/tools/idea/gradle/structure/model/PsQuickFix;", "moduleGradlePath", "", "buildTypeName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "buildType", "Lcom/android/tools/idea/gradle/structure/model/android/PsBuildType;", "(Lcom/android/tools/idea/gradle/structure/model/android/PsBuildType;)V", "getModuleGradlePath", "()Ljava/lang/String;", "getBuildTypeName", "text", "getText", "execute", "", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.projectSystem.gradle.psd"})
public final class PsMissingBuildTypeFallbackQuickFix
implements PsQuickFix {
    @NotNull
    private final String moduleGradlePath;
    @NotNull
    private final String buildTypeName;

    public PsMissingBuildTypeFallbackQuickFix(@NotNull String moduleGradlePath, @NotNull String buildTypeName) {
        Intrinsics.checkNotNullParameter((Object)moduleGradlePath, (String)"moduleGradlePath");
        Intrinsics.checkNotNullParameter((Object)buildTypeName, (String)"buildTypeName");
        this.moduleGradlePath = moduleGradlePath;
        this.buildTypeName = buildTypeName;
    }

    @NotNull
    public final String getModuleGradlePath() {
        return this.moduleGradlePath;
    }

    @NotNull
    public final String getBuildTypeName() {
        return this.buildTypeName;
    }

    public PsMissingBuildTypeFallbackQuickFix(@NotNull PsBuildType buildType) {
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        this(buildType.getParent().getGradlePath(), buildType.getName());
    }

    @Override
    @NotNull
    public String getText() {
        return "Add Fallback";
    }

    @Override
    public void execute(@NotNull PsContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsModule psModule = context.getProject().findModuleByGradlePath(this.moduleGradlePath);
        Intrinsics.checkNotNull((Object)psModule, (String)"null cannot be cast to non-null type com.android.tools.idea.gradle.structure.model.android.PsAndroidModule");
        PsAndroidModule sourceModule = (PsAndroidModule)psModule;
        PsBuildType psBuildType = sourceModule.findBuildType(this.buildTypeName);
        if (psBuildType == null) {
            return;
        }
        PsBuildType buildType = psBuildType;
        ApplicationManager.getApplication().invokeLater(() -> PsMissingBuildTypeFallbackQuickFix.execute$lambda$0(context, buildType));
    }

    @NotNull
    public final String component1() {
        return this.moduleGradlePath;
    }

    @NotNull
    public final String component2() {
        return this.buildTypeName;
    }

    @NotNull
    public final PsMissingBuildTypeFallbackQuickFix copy(@NotNull String moduleGradlePath, @NotNull String buildTypeName) {
        Intrinsics.checkNotNullParameter((Object)moduleGradlePath, (String)"moduleGradlePath");
        Intrinsics.checkNotNullParameter((Object)buildTypeName, (String)"buildTypeName");
        return new PsMissingBuildTypeFallbackQuickFix(moduleGradlePath, buildTypeName);
    }

    public static /* synthetic */ PsMissingBuildTypeFallbackQuickFix copy$default(PsMissingBuildTypeFallbackQuickFix psMissingBuildTypeFallbackQuickFix, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = psMissingBuildTypeFallbackQuickFix.moduleGradlePath;
        }
        if ((n & 2) != 0) {
            string2 = psMissingBuildTypeFallbackQuickFix.buildTypeName;
        }
        return psMissingBuildTypeFallbackQuickFix.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "PsMissingBuildTypeFallbackQuickFix(moduleGradlePath=" + this.moduleGradlePath + ", buildTypeName=" + this.buildTypeName + ")";
    }

    public int hashCode() {
        int result2 = this.moduleGradlePath.hashCode();
        result2 = result2 * 31 + this.buildTypeName.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PsMissingBuildTypeFallbackQuickFix)) {
            return false;
        }
        PsMissingBuildTypeFallbackQuickFix psMissingBuildTypeFallbackQuickFix = (PsMissingBuildTypeFallbackQuickFix)other;
        if (!Intrinsics.areEqual((Object)this.moduleGradlePath, (Object)psMissingBuildTypeFallbackQuickFix.moduleGradlePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildTypeName, (Object)psMissingBuildTypeFallbackQuickFix.buildTypeName);
    }

    private static final void execute$lambda$0(PsContext $context, PsBuildType $buildType) {
        $context.getMainConfigurable().navigateTo($buildType.getPath().property((ModelProperty)PsBuildType.BuildTypeDescriptors.INSTANCE.getMatchingFallbacks()).getPlaceDestination($context), true);
    }
}

