/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.toolchain;

import com.android.tools.idea.gradle.extensions.GradleDaemonJvmPropertiesFileExtensionsKt;
import com.android.utils.FileUtils;
import com.google.common.io.Resources;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.properties.GradleDaemonJvmPropertiesFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/gradle/toolchain/GradleDaemonJvmCriteriaTemplatesManager;", "", "<init>", "()V", "TEMPLATE_CRITERIA_PROPERTIES_FILE_FORMAT", "", "TEMPLATE_METADATA_FILE", "TEMPLATE_RESOURCES_PATH", "generatePropertiesFile", "Ljava/util/concurrent/CompletableFuture;", "", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "externalProjectPath", "Lorg/jetbrains/annotations/SystemIndependent;", "canGeneratePropertiesFile", "getTemplateCriteriaPropertiesContent", "getTemplatePropertiesFileName", "version", "getTemplateMetadata", "Ljava/net/URL;", "intellij.android.projectSystem.gradle"})
public final class GradleDaemonJvmCriteriaTemplatesManager {
    @NotNull
    public static final GradleDaemonJvmCriteriaTemplatesManager INSTANCE = new GradleDaemonJvmCriteriaTemplatesManager();
    @NotNull
    public static final String TEMPLATE_CRITERIA_PROPERTIES_FILE_FORMAT = "gradle-daemon-jvm-%d.properties";
    @NotNull
    public static final String TEMPLATE_METADATA_FILE = "metadata.properties";
    @NotNull
    public static final String TEMPLATE_RESOURCES_PATH = "/templates/project/toolchain/";

    private GradleDaemonJvmCriteriaTemplatesManager() {
    }

    @NotNull
    public final CompletableFuture<Boolean> generatePropertiesFile(@NotNull JavaVersion javaVersion, @NotNull String externalProjectPath) {
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        try {
            String propertiesContent = this.getTemplateCriteriaPropertiesContent(javaVersion);
            CharSequence charSequence = propertiesContent;
            if (charSequence == null || charSequence.length() == 0) {
                v0 = completableFuture.complete(false);
            } else {
                File jvmCriteriaPropertiesFile = GradleDaemonJvmPropertiesFileExtensionsKt.getPropertyPath(GradleDaemonJvmPropertiesFile.INSTANCE, externalProjectPath).toFile();
                FileUtils.writeToFile((File)jvmCriteriaPropertiesFile, (String)propertiesContent);
                v0 = completableFuture.complete(true);
            }
        }
        catch (Exception e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture;
    }

    public final boolean canGeneratePropertiesFile(@NotNull JavaVersion javaVersion) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        try {
            bl = this.getTemplateCriteriaPropertiesContent(javaVersion) != null;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @VisibleForTesting
    @Nullable
    public final String getTemplateCriteriaPropertiesContent(@NotNull JavaVersion javaVersion) {
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        String propertiesTemplatePath = TEMPLATE_RESOURCES_PATH + this.getTemplatePropertiesFileName(javaVersion);
        URL propertiesResourceUrl = Resources.getResource(GradleDaemonJvmCriteriaTemplatesManager.class, (String)propertiesTemplatePath);
        return Resources.toString((URL)propertiesResourceUrl, (Charset)StandardCharsets.UTF_8);
    }

    @VisibleForTesting
    @NotNull
    public final String getTemplatePropertiesFileName(@NotNull JavaVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        String string = TEMPLATE_CRITERIA_PROPERTIES_FILE_FORMAT;
        Object[] objectArray = new Object[]{version2.feature};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @VisibleForTesting
    @NotNull
    public final URL getTemplateMetadata() {
        String metadataPath = "/templates/project/toolchain/metadata.properties";
        URL uRL = Resources.getResource(GradleDaemonJvmCriteriaTemplatesManager.class, (String)metadataPath);
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"getResource(...)");
        return uRL;
    }
}

