/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.DynamicAppFeatureOnFeatureToken;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.projectsystem.gradle.LinkedAndroidModuleGroupUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\bH\u0016J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u0011\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/util/DynamicAppFeatureOnFeatureGradleToken;", "Lcom/android/tools/idea/projectsystem/DynamicAppFeatureOnFeatureToken;", "Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystem;", "Lcom/android/tools/idea/projectsystem/GradleToken;", "<init>", "()V", "getFeatureModulesDependingOnFeature", "", "Lcom/intellij/openapi/module/Module;", "projectSystem", "module", "getFeatureModuleDependenciesForFeature", "selectFeatureModules", "moduleStream", "Ljava/util/stream/Stream;", "removeModulesInTheSameGradleProject", "modules", "moduleOfProjectToRemove", "intellij.android.projectSystem.gradle"})
public final class DynamicAppFeatureOnFeatureGradleToken
implements DynamicAppFeatureOnFeatureToken<GradleProjectSystem>,
GradleToken {
    @Override
    @NotNull
    public List<Module> getFeatureModulesDependingOnFeature(@NotNull GradleProjectSystem projectSystem, @NotNull Module module) {
        List<Module> list;
        Intrinsics.checkNotNullParameter((Object)projectSystem, (String)"projectSystem");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            list = CollectionsKt.emptyList();
        } else {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Stream<Module> stream = ModuleManager.Companion.getInstance(project).getModuleDependentModules(LinkedAndroidModuleGroupUtilsKt.getMainModule(module)).stream();
            Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
            list = this.selectFeatureModules(this.removeModulesInTheSameGradleProject(stream, module));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Module> getFeatureModuleDependenciesForFeature(@NotNull GradleProjectSystem projectSystem, @NotNull Module module) {
        List<Module> list;
        Intrinsics.checkNotNullParameter((Object)projectSystem, (String)"projectSystem");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!((Boolean)StudioFlags.SUPPORT_FEATURE_ON_FEATURE_DEPS.get()).booleanValue()) {
            list = CollectionsKt.emptyList();
        } else {
            Module[] moduleArray = ModuleRootManager.getInstance((Module)LinkedAndroidModuleGroupUtilsKt.getMainModule(module)).getDependencies();
            Stream<Module> stream = Stream.of(Arrays.copyOf(moduleArray, moduleArray.length));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
            list = this.selectFeatureModules(this.removeModulesInTheSameGradleProject(stream, module));
        }
        return list;
    }

    private final List<Module> selectFeatureModules(Stream<Module> moduleStream) {
        List<Module> list = moduleStream.map(arg_0 -> DynamicAppFeatureOnFeatureGradleToken.selectFeatureModules$lambda$1(DynamicAppFeatureOnFeatureGradleToken::selectFeatureModules$lambda$0, arg_0)).distinct().filter(arg_0 -> DynamicAppFeatureOnFeatureGradleToken.selectFeatureModules$lambda$3(DynamicAppFeatureOnFeatureGradleToken::selectFeatureModules$lambda$2, arg_0)).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"collect(...)");
        return list;
    }

    private final Stream<Module> removeModulesInTheSameGradleProject(Stream<Module> modules, Module moduleOfProjectToRemove) {
        Stream<Object> stream = modules.filter(arg_0 -> DynamicAppFeatureOnFeatureGradleToken.removeModulesInTheSameGradleProject$lambda$5(arg_0 -> DynamicAppFeatureOnFeatureGradleToken.removeModulesInTheSameGradleProject$lambda$4(moduleOfProjectToRemove, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
        return stream;
    }

    @Override
    public boolean isApplicable(@NotNull AndroidProjectSystem projectSystem) {
        return GradleToken.super.isApplicable(projectSystem);
    }

    private static final Module selectFeatureModules$lambda$0(Module it) {
        Intrinsics.checkNotNull((Object)it);
        return LinkedAndroidModuleGroupUtilsKt.getHolderModule(it);
    }

    private static final Module selectFeatureModules$lambda$1(Function1 $tmp0, Object p0) {
        return (Module)$tmp0.invoke(p0);
    }

    private static final boolean selectFeatureModules$lambda$2(Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(module);
        AndroidModuleSystem.Type type = moduleSystem.getType();
        return type == AndroidModuleSystem.Type.TYPE_FEATURE || type == AndroidModuleSystem.Type.TYPE_DYNAMIC_FEATURE;
    }

    private static final boolean selectFeatureModules$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeModulesInTheSameGradleProject$lambda$4(Module $moduleOfProjectToRemove, Module m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        return LinkedAndroidModuleGroupUtilsKt.getHolderModule(m) != LinkedAndroidModuleGroupUtilsKt.getHolderModule($moduleOfProjectToRemove);
    }

    private static final boolean removeModulesInTheSameGradleProject$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

